//
//              Copyright 2004 (C) by UCAR
//

#ifndef ATDISFF_USERCLOCKEDA2DSAMPLER_H
#define ATDISFF_USERCLOCKEDA2DSAMPLER_H

#include <atdISFF/A2DSampler.h>
#include <atdISFF/TimerThread.h>

namespace atdISFF {

/**
 * Interface for an A2DSampler that is user clocked, which means it
 * has to request the A2D conversions itself, in its run() method.
 * If passed a TimerThread, it will wait on the TimerThread's Cond variable
 * in its run() loop. Otherwise it creates its own TimerThread.
 */
class UserClockedA2DSampler : public virtual A2DSampler {
public:
  UserClockedA2DSampler(const std::string& name,TimerThread* tt) :
  	A2DSampler(name),timer(tt) {}

  virtual float getMaximumSamplingRate() const = 0;

  virtual void addChannel(int num, int voltageRangeIndex, float samplingRate)
  	throw(atdUtil::IOException,atdUtil::InvalidParameterException) = 0;

protected:

  /**
   * The TimerThread is the clock that we wait on in 
   * our run() method.
   */
  TimerThread* timer;
};

}

#endif
