//
//              Copyright 2004 (C) by UCAR
//

#ifndef ATDISFF_TIMERTHREAD_H
#define ATDISFF_TIMERTHREAD_H

#include <atdUtil/Thread.h>
#include <atdUtil/ThreadSupport.h>

#include <sys/time.h>

namespace atdISFF {

class TimerThread : public atdUtil::Thread {
public:

  TimerThread(const std::string& name);
  ~TimerThread();

  virtual int run() throw(atdUtil::Exception);

  virtual void interrupt();

  /**
   * Set the wakeup interval in milliseconds.
   */
  void setWakeupIntervalMsec(unsigned int msec);
  unsigned int getWakeupIntervalMsec() const;

  /**
   * Set the wakeup rate in hertz
   */
  void setWakeupRate(float val);
  float getWakeupRate() const;

  void lock() { timerCond.lock(); }
  void unlock() { timerCond.unlock(); }
  void wait() { timerCond.wait(); }

public:
  long long currentTimeMsec() {
    struct timeval currentTime;
    gettimeofday(&currentTime,0);
    return (long long)currentTime.tv_sec * 1000 + currentTime.tv_usec / 1000;
  }

protected:
  atdUtil::Cond timerCond;
  unsigned long mSecSleep;
};
}

#endif
