//
//              Copyright 2004 (C) by UCAR
//

#include <atdISFF/TimeTagSmoother.h>

#include <unistd.h>	// sleep

using namespace atdISFF;
using namespace std;

isff_sys_time_t TimeTagSmoother::getTime(isff_sys_time_t t,int nsamp,
	double & deltat)
{
    if (ntime < T0_STATS) {
        tsum += t;
	isum += ntime;
	
        if (ntime == 0) {
	    t0 = tlast = t;
	    ntime++;
	}
	else updateDtAvg(t);

	if (ntime == T0_STATS) {
	    t0 = (tsum - isum * (t - t0) / (ntime - 1)) / ntime;
	    tcor = t0 + (ntime - 1) * dtavg;
	    dtsave = deltat = dtavg / nsamp;
	    return tcor;
	}
	else return t;
    }

    // generate time tag
    tcor = isff_sys_time_add(tcor, dtsave * nsamp);

    updateDtAvg(t);

    double terr = t - tcor;
    updateTerrAvg(terr);

    // next deltat is the average plus 10% of the error
    dtsave = dtavg / nsamp + (terravg / nsamp / 10);
    if (dtsave < 0.0) dtsave = 0.0;
    deltat = dtsave;

#ifdef DEBUG
    cerr << "dtavg=" << dtavg << " " << dtavg / nsamp << " terravg=" << terravg << endl;
#endif

    return tcor;
    
}
    
int TimeTagSmoother::test(double var)
{

    TimeTagSmoother smthr;

    // double dtorig = 0.501;
    double dtorig = 16.670;
    double dt = 1000.0/60.0;
    // int nsamp = 57;
    int nsamp = 1;
    // double var = 50.;	// milliseconds

    srandom(time(0));

    isff_sys_time_t t = 0;
    isff_sys_time_t tnewlast = 0;

    for (;;) {
	for (int i = 0; i < 20; i++) {
	    long int r = random();
	    double eps = double(r - RAND_MAX/2) / RAND_MAX/2;
	    isff_sys_time_t tx = t + var * eps;
	    isff_sys_time_t tnew = smthr.getTime(tx,nsamp,dt);

	    cerr << "tx=" << tx << " tnew=" << tnew <<
		    " diff=" << tx - tnew <<
		    " dtnew=" << (i == 0 ? 0.0 : tnew - tnewlast) <<
		    " dt=" << dt << " dtorig=" << dtorig * nsamp << endl;
	    t += nsamp * dtorig;
	    tnewlast = tnew;
	}
	sleep(5);
    }
    return 0;
}
    

