//
//              Copyright 2004 (C) by UCAR
//

#ifndef ATDISFF_SERIALPORTCONFIG_H
#define ATDISFF_SERIALPORTCONFIG_H

#include <string>
#include <atdTermio/SerialPort.h>

namespace atdISFF {

class SerialPortConfig {
protected:
  int channel;
  int baud;
  enum atdTermio::SerialPort::parity parityVal;
  int databits;
  int stopbits;
  enum atdTermio::SerialPort::flowcontrol flowcontrolVal;
  int length;
  std::string delimiter;
  bool delimiterAtEOM;

public:
  int getChannel() const { return channel; }
  int getBaud() const { return baud; }
  atdTermio::SerialPort::parity getParity() const { return parityVal; }

  int getDataBits() const { return databits; }
  int getStopBits() const { return stopbits; }
  atdTermio::SerialPort::flowcontrol getFlowControl() const
  	{ return flowcontrolVal; }

  int getRecordLength() const { return length; }
  std::string getRecordDelimiter() const { return delimiter; }
  bool getDelimiterAtEOM() const { return delimiterAtEOM; }

  void setChannel(int val) { channel = val; }
  void setBaud(int val) { baud = val; }
  void setParity(atdTermio::SerialPort::parity val)
  	{ parityVal = val; }
  void setDataBits(int val) { databits = val; }
  void setStopBits(int val) { stopbits = val; }
  void setFlowControl(atdTermio::SerialPort::flowcontrol val)
  	{ flowcontrolVal = val; }
  void setRecordLength(int val) { length = val; }
  void setRecordDelimiter(std::string val) { delimiter = val; }
  void setDelimiterAtEOM(bool val) { delimiterAtEOM = val; }

  SerialPortConfig(): channel(200),baud(9600),
  	parityVal(atdTermio::SerialPort::NONE),
  	databits(8),stopbits(1),
	flowcontrolVal(atdTermio::SerialPort::NOFLOWCONTROL),
	length(0),delimiter(std::string(1,'\n')),delimiterAtEOM(true) {}
};
}


#endif
