/*              Copyright 2004 (C) by UCAR
 *
 * File       : Sampler.h,v
 * Revision   : 1.14
 * Directory  : /code/cvs/isa/src/lib/atdISFF/Sampler.h,v
 * System     : PAM
 * Date       : 2005/01/16 01:34:24
 *
 * Description:
 *
 * Sampler.h,v
 * Revision 1.14  2005/01/16 01:34:24  maclean
 * added copyright
 *
 * Revision 1.13  2004/09/03 12:58:10  maclean
 * added getRawSampleSocket method
 *
 * Revision 1.12  2004/08/30 13:07:04  maclean
 * *** empty log message ***
 *
 * Revision 1.11  2004/08/30 05:13:19  maclean
 * now a stripped down base class
 *
 */
                                                                                
#ifndef ATDISFF_SAMPLER_H
#define ATDISFF_SAMPLER_H

#include <atdUtil/Exception.h>
#include <atdISFF/RawSampleSocket.h>
#include <signal.h>

namespace atdISFF {

class Sampler {

public:

  Sampler();
  virtual ~Sampler();

  static Sampler* getInstance();

  virtual const std::string& getName() const = 0;

  /**
   * Send interrupts to all my threads to stop run methods.
   * Interrupt my run method if I have one.
   */
  virtual void interrupt() = 0;

  /**
   * Do interrupt, but then exit.
   */
  virtual void quit() = 0;

  /**
   * Send a signal to my process id.
   */
  virtual void kill(int sig) throw(atdUtil::Exception);

  static void sigAction(int sig, siginfo_t* siginfo, void* vptr);

  static Sampler* _instance;

  virtual RawSampleSocket* getRawSampleSocket() const = 0;

protected:

  pid_t _pid;

};

}

#endif
