//
//              Copyright 2004 (C) by UCAR
//

#include <sys/types.h>	// getpid()
#include <unistd.h>	// getpid()
#include <string>

#include <atdISFF/Sampler.h>
#include <atdUtil/Thread.h>
#include <atdUtil/Logger.h>

using namespace atdISFF;
using namespace atdUtil;
using namespace std;

/* static */
Sampler* Sampler::getInstance()
{
  return _instance;
}

Sampler::Sampler():
      _pid(getpid())
{
  _instance = this;

  sigset_t sigset;
  sigemptyset(&sigset);
  sigaddset(&sigset,SIGHUP);
  sigaddset(&sigset,SIGTERM);
  sigaddset(&sigset,SIGINT);
  sigprocmask(SIG_UNBLOCK,&sigset,(sigset_t*)0);
                                                                                
  struct sigaction act;
  sigemptyset(&sigset);
  act.sa_mask = sigset;
  act.sa_flags = SA_SIGINFO;
  act.sa_sigaction = sigAction;
  sigaction(SIGHUP,&act,(struct sigaction *)0);
  sigaction(SIGINT,&act,(struct sigaction *)0);
  sigaction(SIGTERM,&act,(struct sigaction *)0);
}

Sampler::~Sampler()
{
  _instance = 0;
}

/* static */
Sampler* Sampler::_instance = 0;

void Sampler::kill(int sig) throw(Exception)
{
  if (::kill(_pid,sig) < 0) throw Exception(getName(),"kill");
}

/* static */
void Sampler::sigAction(int sig, siginfo_t* siginfo, void* vptr) {
  if (!Sampler::getInstance()) {
    Logger::getInstance()->log(LOG_ERR,"No sampler to signal!");
    return;
  }

  Thread* thrptr = Thread::currentThread();
  string tname;
  if (thrptr) tname = thrptr->getName();
  Logger::getInstance()->log(LOG_INFO,
"%s: received signal %s (%d), thread: %s (%d) si_signo=%d, si_errno=%d, \
si_code=%d",
    getInstance()->getName().c_str(),strsignal(sig),sig,
    tname.c_str(),Thread::currentThreadId(),
    siginfo ? siginfo->si_signo : -1,
    siginfo ? siginfo->si_errno : -1,
    siginfo ? siginfo->si_code : -1);

  switch(sig) {
  case SIGHUP:
    getInstance()->interrupt();
    break;
  case SIGTERM:
  case SIGINT:
    getInstance()->quit();
    break;
  }
}
