//
//              Copyright 2004 (C) by UCAR
//

#ifndef ATDISFF_SAMPLEFORMATTER_H
#define ATDISFF_SAMPLEFORMATTER_H

#include <atdISFF/RawSampleSource.h>

namespace atdISFF {

class SampleFormatter: public RawSampleClient, public RawSampleSource {
public:
  SampleFormatter();

  virtual ~SampleFormatter();

  enum varType { LICOR820, A2D, RELAY };

  bool receive(const RawSample *sample) throw(atdUtil::IOException);

  void addVariable(varType type,const std::string& name, int channel);

  void addVariable(varType type,const std::string& name, int channel,
  	float a2dslope, float a2dintercept);

  void setDeltatMsec(int val) { deltatMsec = val; deltatMsec2 = val/2; }

protected:

  void init();
  void initData();
  void format() throw(atdUtil::IOException);

  std::vector<std::string> varnames;
  std::vector<int> channelNumbers;
  std::vector<varType> types;
  std::vector<float> a2dslope;
  std::vector<float> a2dintercept;

  float *data;
  unsigned char* relayBits;
  int relayBitsLen;

  int deltatMsec;

  int deltatMsec2;

  long nextOutputTime;

};

}

#endif
