//
//              Copyright 2004 (C) by UCAR
//

#include <atdISFF/Rserial.h>

#include <unistd.h>
#include <fcntl.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <errno.h>
#include <stdio.h>

using namespace std;
using namespace atdISFF;
using namespace atdUtil;

/**
 * Open socket for listening on port 8100.
 */
Rserial::Rserial() throw(IOException) : RSERIAL_PORT(8100) {

  if ((socketfd = socket(AF_INET,SOCK_STREAM,0)) < 0)
    throw IOException("rserial socket","open",errno);

  int i = 1;
  if (setsockopt(socketfd,SOL_SOCKET,SO_REUSEADDR,
	      (char *)&i,sizeof i) < 0)
    throw IOException("rserial socket","setsockopt",errno);

  struct sockaddr_in myAddr;
  memset(&myAddr,0,sizeof myAddr);
  myAddr.sin_family = AF_INET;
  myAddr.sin_port = htons(RSERIAL_PORT);

  if (bind(socketfd, (struct sockaddr *) & myAddr, sizeof(myAddr)) < 0) {
    ::close(socketfd);
    socketfd = -1;
    throw IOException("rserial socket","bind",errno);
  }

  if (listen(socketfd, 2) < 0) {
    close(socketfd);
    socketfd = -1;
    throw IOException("rserial socket","listen",errno);
  }
}

Rserial::~Rserial() throw (IOException) {
  if (socketfd >= 0 && ::close(socketfd) < 0)
    throw IOException("rserial socket","close",errno);
}

Rserial::Connection Rserial::acceptConnection() throw(IOException) {

  struct sockaddr_in clientAddr;
  socklen_t client_len = sizeof(clientAddr);
 
  int csock = accept(socketfd, (struct sockaddr *) & clientAddr, &client_len);

  if (csock < 0)
    throw IOException("rserial socket","accept",errno);

  /*
   * the first message will have the channel number in it.
   */
  char buffer[128];
  int n = recv(csock, buffer, (sizeof buffer) -1, 0);
  if (n < 0)
    throw IOException("rserial socket","recv",errno);
 
  buffer[n] = 0;
  int channel;
  sscanf(buffer, "%d", &channel);

  // cerr << "rserial accepted connection for channel " << channel << endl;

  int flags;
  /* set io to non-blocking, so network jams don't hang us up */
  if ((flags = fcntl(csock, F_GETFL, 0)) < 0)
    throw IOException("rserial socket","fcntl(...,F_GETFL,...)",errno);

  if (fcntl(csock, F_SETFL, flags | O_NONBLOCK) < 0)
    throw IOException("rserial socket","fcntl(...,F_SETFL,O_NONBLOCK)",errno);

  return Connection(csock,channel);
}
