//
//              Copyright 2004 (C) by UCAR
//

#ifndef ATDISFF_RELAY_H
#define ATDISFF_RELAY_H

#include <atdUtil/BitArray.h>
#include <atdUtil/IOException.h>

namespace atdISFF {

class Relay {
public:

  virtual ~Relay() {}

  virtual const std::string& getName() const = 0;

  virtual atdUtil::BitArray& getRelayBits() = 0;

  virtual void setRelayBits(const atdUtil::BitArray&) = 0;

  /**
   * Set the relays to the current value of the relay mask.
   */
  virtual void setRelays() throw(atdUtil::IOException) = 0;

  virtual const atdUtil::BitArray& readRelays() throw(atdUtil::IOException) = 0;

  virtual void openRelays() throw(atdUtil::IOException) = 0;

  virtual void reset() throw(atdUtil::IOException) {}

};

}

#endif

