//
//              Copyright 2004 (C) by UCAR
//


#ifndef ATDISFF_RAWSAMPLESOURCE_H
#define ATDISFF_RAWSAMPLESOURCE_H

#include <list>

#include <atdISFF/RawSampleClient.h>

namespace atdISFF {

class RawSampleSource {
public:

  void addRawSampleClient(RawSampleClient*);
  void removeRawSampleClient(RawSampleClient*);
  void removeAllRawSampleClients();

  unsigned long getNumSamplesSent() const { return numSamplesSent; }
  void setNumSamplesSent(unsigned long val) { numSamplesSent = val; }

  /**
   * Distribute this sample to my clients.
   */
  void distribute(const RawSample*) throw(atdUtil::IOException);

  /**
   * Distribute this sample to my clients, but if any client's
   * receive method throws and IOException, remove the client.
   */
  void distributeDiscOnExc(const RawSample*) throw(atdUtil::IOException);

protected:

  /**
   * mutex to prevent simultaneous access to clients list
   */
  atdUtil::Mutex clistLock;

  /**
   * My current clients.
   */
  std::list<RawSampleClient*> clients;

  /**
   * Number of samples distributed.
   */
  int numSamplesSent;

};
}

#endif
