//
//              Copyright 2004 (C) by UCAR
//

#include <atdISFF/RawSampleSource.h>
#include <atdUtil/Logger.h>

using namespace atdISFF;

void RawSampleSource::addRawSampleClient(RawSampleClient* client) {
  clistLock.lock();
  clients.push_back(client);
  clistLock.unlock();
}

void RawSampleSource::removeRawSampleClient(RawSampleClient* client) {
  clistLock.lock();
  std::list<RawSampleClient*>::iterator li;
  for (li = clients.begin(); li != clients.end(); ) {
    if (*li == client) li = clients.erase(li);
    else ++li;
  }
  clistLock.unlock();
}
  
void RawSampleSource::removeAllRawSampleClients() {
  clistLock.lock();
  clients.clear();
  clistLock.unlock();
}
  
void RawSampleSource::distribute(const RawSample* sample) throw(atdUtil::IOException) {

  clistLock.lock();
  std::list<RawSampleClient*> tmp = clients;
  clistLock.unlock();

  std::list<RawSampleClient*>::iterator li;
  for (li = tmp.begin(); li != tmp.end(); ++li)
    (*li)->receive(sample);
  sample->freeReference();
  numSamplesSent++;
}

void RawSampleSource::distributeDiscOnExc(const RawSample* sample) throw(atdUtil::IOException) {

  clistLock.lock();
  std::list<RawSampleClient*> tmp = clients;
  clistLock.unlock();

  std::list<RawSampleClient*>::iterator li;
  for (li = tmp.begin(); li != tmp.end(); ++li) {
    try {
      (*li)->receive(sample);
    }
    catch (atdUtil::IOException& ioe) {
      // remove the client and re-throw
      removeRawSampleClient(*li);
      atdUtil::Logger::getInstance()->log(LOG_ERR,"%s\n",ioe.what());
      // sample->freeReference();
      // throw ioe;
    }
  }
  sample->freeReference();
  numSamplesSent++;
}
