//
//              Copyright 2004 (C) by UCAR
//

#include <atdISFF/RawSampleSocketReOpener.h>
#include <atdISFF/RawSampleSocket.h>
#include <atdUtil/Logger.h>

using namespace atdISFF;
using namespace atdUtil;

RawSampleSocketReOpener::RawSampleSocketReOpener(RawSampleSocket* skt):
    Thread("RawSampleSocketReOpener",true),	// detached thread
    socket(skt)
{
  // This will be a detached thread.  When the run method is finished
  // the destructor will be called.
  unblockSignal(SIGUSR1);
}

RawSampleSocketReOpener::~RawSampleSocketReOpener()
{
  Logger::getInstance()->log(LOG_DEBUG,"%s destructor",
  	getName().c_str());
}

int RawSampleSocketReOpener::run() throw(atdUtil::Exception)
{

  struct timespec stime;
  stime.tv_sec = 15;
  stime.tv_nsec = 0;

  for (;;) {
    nanosleep(&stime,0);
    if (amInterrupted()) break;
    try {
      socket->open();
      break;		// success
    }
    catch (atdUtil::UnknownHostException& uhe) {
      Logger::getInstance()->log(LOG_ERR,
	    "RawSamplerSocketReOpener: %s", uhe.what());
      throw Exception(uhe);
    }
    catch (atdUtil::IOException& ioe) {
      Logger::getInstance()->log(LOG_ERR,
	    "RawSamplerSocketReOpener: %s",ioe.what());
    }
  }
  return Thread::RUN_OK;
}
