//
//              Copyright 2004 (C) by UCAR
//

#ifndef ATDISFF_RAWSAMPLESOCKET_H
#define ATDISFF_RAWSAMPLESOCKET_H

#include <atdUtil/UnknownHostException.h>
#include <atdUtil/IOException.h>
#include <atdISFF/RawSampleClient.h>
#include <atdISFF/FieldDataSocket.h>
#include <atdISFF/RawSampleSocketReOpener.h>

namespace atdISFF {

class RawSampleSocket : public FieldDataSocket, public RawSampleClient {
public:

  RawSampleSocket(const std::string& serverName);
  ~RawSampleSocket();

  void open() throw(atdUtil::UnknownHostException,atdUtil::IOException);
  void reopen() throw(atdUtil::Exception);

  bool receive(const RawSample *sample) throw(atdUtil::IOException);

  size_t getNumLostSamples() const { return _lostSamples; }

  int getNumWriteErrors() const { return _nwriteErr; }

  float getSamplesPerSec() const { return getWritesPerSec(); }

protected:

  size_t _lostSamples;

  int _nwriteErr;

  RawSampleSocketReOpener* _opener;
};
}
#endif
