//
//              Copyright 2004 (C) by UCAR
//

#ifndef ATDISFF_RAWSAMPLESET_H
#define ATDISFF_RAWSAMPLESET_H
#include <atdISFF/RawSample.h>

#include <set>

namespace atdISFF {

class RawSampleCmp {
public:
  bool operator() (const RawSample* x, const RawSample *y) const {
    // return true if x is less than y
    int d = x->tt - y->tt;
    if (d < 0) {
      if (d < -86100000) return false;	// x has rolled over back to 0
      return true;
    }
    else {
      if (d > 86100000) return true;	// y has rolled over back to 0
      return false;
    }
  }
};

class RawSampleSet: public std::multiset<const RawSample*,RawSampleCmp> {};

}

#endif
