//
//              Copyright 2004 (C) by UCAR
//

#ifndef ATDISFF_RAWSAMPLEPOOL_H
#define ATDISFF_RAWSAMPLEPOOL_H

#include <atdUtil/ThreadSupport.h>
#include <vector>


namespace atdISFF {

class RawSample;

class RawSamplePool {

private:
  static RawSamplePool* instance;

public:
  RawSamplePool();
  ~RawSamplePool();

  RawSample *getRawSample(int len);
  void putRawSample(RawSample *);

  static RawSamplePool *getInstance();

protected:
  RawSample *getRawSample(RawSample** vec,int *veclen, int len);
  void putRawSample(RawSample *,RawSample*** vecp,int *veclen, int* nalloc);

  RawSample** smallSamples;
  RawSample** bigSamples;

  int smallSize;
  int bigSize;
  int nsmall;
  int nbig;
  int nsamplesCreated;

  atdUtil::Mutex poolLock;

};
}

#endif
