//
//              Copyright 2004 (C) by UCAR
//

#include <atdISFF/RawSamplePool.h>
#include <atdISFF/RawSample.h>
#include <atdUtil/ThreadSupport.h>

#include <iostream>

using namespace atdISFF;
using namespace atdUtil;
using namespace std;

/* static */
RawSamplePool* RawSamplePool::instance = new RawSamplePool();

RawSamplePool* RawSamplePool::getInstance() { return instance; }

RawSamplePool::RawSamplePool(): smallSize(512),bigSize(128),nsmall(0),
	nbig(0),nsamplesCreated(0) {
  smallSamples = new RawSample*[smallSize];
  bigSamples = new RawSample*[bigSize];
}

RawSamplePool::~RawSamplePool() {
  int i;
  for (i = 0; i < nsmall; i++) delete smallSamples[i];
  delete [] smallSamples;
  for (i = 0; i < nbig; i++) delete bigSamples[i];
  delete [] bigSamples;
}

RawSample* RawSamplePool::getRawSample(int len) {
  Synchronized pooler(poolLock);

#ifdef DEBUG
  cerr << "smallSamples.size=" << smallSamples.size() <<
    " bigSamples.size=" << bigSamples.size() << endl;
#endif

  if (len < 20) return getRawSample(smallSamples,&nsmall,len);
  else return getRawSample(bigSamples,&nbig,len);
}

RawSample* RawSamplePool::getRawSample(RawSample** vec,
    	int *n, int len) {

  RawSample *sample;
  int i = *n - 1;

  if (i >= 0) {
    sample = vec[i];
    if (sample->getAllocLen() < len) sample->setAllocLen(len);
    *n = i;
    sample->holdReference();
    return sample;
  }

  sample = new RawSample();
  sample->setAllocLen(len);
  // if (!(nsamplesCreated++ % 100)) cerr << "*n=" << *n << " nsamplesCreated=" << nsamplesCreated << endl;
  return sample;

}

void RawSamplePool::putRawSample(RawSample *sample) {
  Synchronized pooler(poolLock);
  if (sample->getAllocLen() < 20)
    	putRawSample(sample,&smallSamples,&nsmall,&smallSize);
  else putRawSample(sample,&bigSamples,&nbig,&bigSize);
}

void RawSamplePool::putRawSample(RawSample *sample,
    	RawSample ***vec,int *n, int *nalloc) {
  if (*n == *nalloc) {
    // cerr << "reallocing, n=" << *n << " nalloc=" << *nalloc << endl;
    int newalloc = *nalloc + (*nalloc >> 1);
    RawSample **newvec = new RawSample*[newalloc];
    ::memcpy(newvec,*vec,*nalloc * sizeof(RawSample*));
    delete [] *vec;
    *vec = newvec;
    *nalloc = newalloc;
  }

  (*vec)[(*n)++] = sample;
}
