//
//              Copyright 2004 (C) by UCAR
//

#ifndef ATDISFF_RAWSAMPLECLIENT_H
#define ATDISFF_RAWSAMPLECLIENT_H

#include <atdISFF/RawSample.h>
#include <atdUtil/IOException.h>

namespace atdISFF {

class RawSampleClient {
public:

  virtual ~RawSampleClient() {}

  /**
   * Method called to pass a sample to this client.
   * Returns
   *   true: success
   *   false: sample rejected. This is meant to signal a
   *     warning-type situation - like a socket not
   *     being available temporarily.  True errors
   *     will be thrown as an IOException.
   */
  virtual bool receive(const RawSample *s) throw(atdUtil::IOException) = 0;

  /**
   * Called by external to reset this RawSampleClient. 
   * For example, re-open a socket.
   */
  virtual void reset(RawSample *s) throw(atdUtil::IOException) {}
};
}

#endif
