//
//              Copyright 2004 (C) by UCAR
//

#ifndef ATDISFF_RAWSAMPLEHANDLER_H
#define ATDISFF_RAWSAMPLEHANDLER_H

#include <atdISFF/RawSampleSet.h>
#include <atdISFF/RawSampleSource.h>
#include <atdUtil/Thread.h>
#include <atdUtil/ThreadSupport.h>
#include <atdUtil/UnknownHostException.h>
#include <atdUtil/IOException.h>

#include <atdISFF/Time.h>

namespace atdISFF {

class RawSampleBuffer : public atdUtil::Thread,
	public RawSampleClient, public RawSampleSource {
public:

  RawSampleBuffer(int buflenInMilliSec);
  virtual ~RawSampleBuffer();

  bool receive(const RawSample *s) throw();

  void interrupt();

  void setThreadSignalFactor(int val) { threadSignalFactor = val; }

  size_t getRawSampleSetSize() const { return samples.size(); }
  size_t getRawSamplesInMemory() const { return RawSample::nsamps; }

protected:

  /**
   * Thread function.
   */
  virtual int run() throw(atdUtil::Exception);

  int buflenInMillisec;
  RawSampleSet samples;
  RawSample dummy;

private:
  atdUtil::Cond samplesAvail;

  int threadSignalFactor;
};
}
#endif
