//
//              Copyright 2004 (C) by UCAR
//

#ifndef ATDISFF_RAWSAMPLEARCHIVEFILE_H
#define ATDISFF_RAWSAMPLEARCHIVEFILE_H

#include <atdUtil/IOException.h>
#include <atdISFF/RawSampleClient.h>
#include <atdISFF/Time.h>

#include <string>

namespace atdISFF {

class RawSampleArchiver: public RawSampleClient {
  const static int MSECS_IN_DAY;
  const static int MSECS_IN_5MIN;
public:
  RawSampleArchiver();
  virtual ~RawSampleArchiver();
  bool receive(const RawSample*) throw(atdUtil::IOException);

  void setDirectoryName(const std::string& val) { directoryName = val; }
  const std::string& getDirectoryName() const { return directoryName; }

  void setFileNameFormat(const std::string& val) { fileNameFormat = val; }
  const std::string& getFileNameFormat() const { return fileNameFormat; }

  void setFileLength(int val) { fileLengthMsecs = val * 1000; }
  int getFileLength() const { return fileLengthMsecs / 1000; }

  int getBadTimeTagCount() const { return badTimeTagCount; }

protected:
  virtual void write(isff_sys_time_t fullTT, const RawSample* samp)
    throw(atdUtil::IOException);

  void openFile(isff_sys_time_t fullTT) throw(atdUtil::IOException);

  void initTime();

  isff_sys_time_t expandTimeTag(unsigned long tt);

  std::string directoryName;
  std::string fileNameFormat;
  int fileLengthMsecs;

  isff_sys_time_t t0day;
  unsigned long lastTT;

  isff_sys_time_t nextFileTime;
  FILE* cfp;
  std::string fileName;
  std::string shortName;

  int badTimeTagCount;

};

}

#endif
