//
//              Copyright 2004 (C) by UCAR
//

#include <atdISFF/RawSample.h>

#ifdef GPP_2_95_2
#include <strstream>
#else
#include <sstream>
#endif

#include <iomanip>

using namespace std;
using namespace atdISFF;

int RawSample::headLen = sizeof(long) + sizeof(char) + sizeof(char);
int RawSample::nsamps = 0;

string RawSample::toString() const {
#ifdef GPP_2_95_2
  ostrstream os;
#else
  ostringstream os;
#endif

  os << "tt=" << tt << " chan=" << (int) chan <<
    " len=" << (int) len << ' ';
  for (int i = 0; i < len; i++)
    os << setfill('0') << setw(2) <<
     	 hex << ((unsigned int)data[i] & 0xff);
  os << dec << ends;
  return os.str();
}


