//
//              Copyright 2004 (C) by UCAR
//

#include <iostream>

#include <atdISFF/RPCSerialPortConfiguration.h>
#include <atdTermio/SerialPort.h>

#include <atdISFF/adamserver.h>
#include <atdUtil/IOException.h>

using namespace std;
using namespace atdISFF;
using namespace atdUtil;

void
RPCSerialPortConfiguration::getConfiguration(const string& server,const string& nodename) throw(IOException) {
  CLIENT *clnt;

  if ((clnt = clnt_create(server.c_str(),ADAMSERVERPROG,ADAMSERVERVERS,"tcp")) == NULL) {
    IOException err(string("adamserver RPC service on ") + server,"call",
    	clnt_spcreateerror(server.c_str()));
    throw(err);
  }

  char nodename_c[nodename.size() + 1];
  strcpy(nodename_c,nodename.c_str());
  siocfg_res *result = getsiocfg_1((char *)&nodename_c,clnt);
  clnt_destroy(clnt);
                                                                                
  if (result == NULL) {
    IOException err(string("adamserver RPC service on ") + server,
    	string("getsiocfg for ") + nodename,
	string(clnt_sperror(clnt,"")));
    throw(err);
  }
                                                                                
  if (result->ierr != 0) {
    IOException err(string("adamserver RPC service on ") + server,
    	string("getsiocfg for ") + nodename,
	result->siocfg_res_u.errmsg);
    xdr_free((bool_t(*)(XDR*,void*,...))xdr_siocfg_res,(char *)result);
    throw(err);
  }

  // enum rectype {ASCII,BINARY,PROMPTEDBINARY,BINARY_END_SYNC} type;

  for (siocfg *scp = result->siocfg_res_u.sio; scp; scp = scp->next) {
    SerialPortConfig cfg;
    cfg.setBaud(scp->baud);
    cfg.setChannel(scp->chan);

    if (scp->c_cflag & PARENB) {
      if (scp->c_cflag & PARODD) cfg.setParity(atdTermio::SerialPort::ODD);
      else cfg.setParity(atdTermio::SerialPort::EVEN);
    }
    else cfg.setParity(atdTermio::SerialPort::NONE);

    int csize = scp->c_cflag & CSIZE;
    switch (csize) {
    case CS7:
      cfg.setDataBits(7);
      cerr << "cfg.setDataBits(7)" << endl;
      break;
    case CS8:
    default:
      cfg.setDataBits(8);
      break;
    }
    if (scp->c_cflag & CSTOPB) cfg.setStopBits(2);
    else cfg.setStopBits(1);

    if (scp->type == ASCII) {
      cfg.setRecordLength(0);
      char eom[2];
      eom[0] = scp->eom;
      eom[1] = 0;
      cfg.setRecordDelimiter(string(eom));
    }
    else {
      cfg.setRecordLength(scp->nbytes);
      cfg.setRecordDelimiter(scp->sync);
      cfg.setDelimiterAtEOM(scp->type == BINARY_END_SYNC);
    }

    configs.push_back(cfg);

    /*
    printf("baud=%d\n",scp->baud);
    printf("chan=%d\n",scp->chan);
    printf("c_cflag=0x%x\n",scp->c_cflag);
    printf("type=%d\n",scp->type);
    printf("nbytes=%d\n",scp->nbytes);
    printf("sync=%#x %#x\n",scp->sync[0],scp->sync[1]);
    */
  }
  xdr_free((bool_t(*)(XDR*,void*,...))xdr_siocfg_res,(char *)result);
}
