//
//              Copyright 2004 (C) by UCAR
//

#include <iostream>

#include <atdISFF/RPCA2DChannelConfiguration.h>

#include <atdISFF/adamserver.h>
#include <atdUtil/IOException.h>

using namespace std;
using namespace atdISFF;
using namespace atdUtil;

void
RPCA2DChannelConfiguration::getConfiguration(const string& server,const string& nodename) throw(IOException) {
  CLIENT *clnt;

  if ((clnt = clnt_create(server.c_str(),ADAMSERVERPROG,ADAMSERVERVERS,"tcp")) == NULL) {
    IOException err(string("adamserver RPC service on ") + server,"call",
    	clnt_spcreateerror(server.c_str()));
    throw(err);
  }

  char nodename_c[nodename.size() + 1];
  strcpy(nodename_c,nodename.c_str());
  analogcfg_res *result = getanalogcfg_1((char *)&nodename_c,clnt);
  clnt_destroy(clnt);
                                                                                
  if (result == NULL) {
    IOException err(string("adamserver RPC service on ") + server,
    	string("getanalogcfg for ") + nodename,
	string(clnt_sperror(clnt,"")));
    throw(err);
  }
                                                                                
  if (result->ierr != 0) {
    IOException err(string("adamserver RPC service on ") + server,
    	string("getanalogcfg for ") + nodename,
	result->analogcfg_res_u.errmsg);
    xdr_free((bool_t(*)(XDR*,void*,...))xdr_analogcfg_res,(char *)result);
    throw(err);
  }

  for (analogcfg *acp = result->analogcfg_res_u.a2d; acp; acp = acp->next) {
    A2DChannelConfig cfg;
    cfg.setChannel(acp->chan);
    cfg.setSamplingRate(acp->hz);
    /*
     * gain and offsets are appropriage for a Datel: -5:5V -> -32767:32767
     * gain offset  Vmin Vmax
     *  1     0     -5    5
     *  2    -5      0    5
     *  .5    0    -10   10
     */
    float minV = (-5.0 - acp->offset) / acp->gain;
    float maxV = (+5.0 - acp->offset) / acp->gain;
    cerr << "gain=" << acp->gain << " offset=" << acp->offset <<
    	" minV=" << minV << " maxV=" << maxV << endl;
    cfg.setMinV(minV);
    cfg.setMaxV(maxV);
    configs.push_back(cfg);
  }
  xdr_free((bool_t(*)(XDR*,void*,...))xdr_analogcfg_res,(char *)result);
}
