/*              Copyright 2004 (C) by UCAR
 *
 * File       : NDaqSampler.h,v
 * Revision   : 1.10
 * Directory  : /code/cvs/isa/src/lib/atdISFF/NDaqSampler.h,v
 * System     : PAM
 * Date       : 2006/01/29 22:25:08
 *
 * Description:
 *
 * NDaqSampler.h,v
 * Revision 1.10  2006/01/29 22:25:08  martinc
 * Added command line option for enabling stepper control.
 *
 * Revision 1.9  2006/01/28 22:27:53  maclean
 * changes so that things build if not using Diamond System universal driver
 *
 * Revision 1.8  2006/01/28 03:45:04  martinc
 * completely reworked to place stepper functions in a thread so that they wdo not block the rpc handling in DaqMonitorRPC.
 *
 * Revision 1.7  2006/01/11 23:07:53  maclean
 * Added buffer length option.
 * Can't seem to send straight to the socket though, which is wierd.......
 *
 * Revision 1.6  2006/01/10 05:02:14  maclean
 * added support for MM32XAT
 *
 * Revision 1.5  2005/12/12 22:38:05  maclean
 * added -M
 *
 * Revision 1.4  2005/12/12 21:08:18  maclean
 * *** empty log message ***
 *
 * Revision 1.3  2005/11/16 18:17:49  maclean
 * fixed a bunch of compiler warnings
 *
 * Revision 1.2  2005/01/16 01:34:21  maclean
 * added copyright
 *
 * Revision 1.1  2004/08/30 05:13:41  maclean
 * *** empty log message ***
 *
 */
                                                                                
#ifndef ATDISFF_NDAQSAMPLER_H
#define ATDISFF_NDAQSAMPLER_H

/* for strsignal */
#ifndef _GNU_SOURCE
#define _GNU_SOURCE
#endif
#include <string.h>
#include <signal.h>

#include <atdISFF/Sampler.h>
#include <atdISFF/RawSampleSocket.h>
#include <atdISFF/RawSampleArchiver.h>
#include <atdISFF/RawSampleBuffer.h>
#include <atdISFF/SensorPortHandler.h>
#include <atdISFF/ExtClockedA2DSampler.h>
#include <atdISFF/DaqMonitorRPC.h>
#include <atdISFF/SampleFormatter.h>
#include <atdISFF/relays/RrelayListener.h>

#ifdef ENABLE_DSCUD
#include <atdISFF/Stepper.h>
#include <dsc/IR104.h>
#endif

#include <atdISFF/relays/RelayParser.h>

#include <vector>
#include <iostream>
#include <time.h>


namespace atdISFF {

class NDaqSampler: public Sampler {

public:

  enum A2Ds { PROM_A2D, MM16AT_A2D, MM32XAT_A2D };

  typedef enum A2Ds A2D_t;

  ~NDaqSampler();

  static NDaqSampler* getNDaqInstance();

  const std::string& getName() const { return _name; }

  void setNodeName(const std::string& val) { _nodename = val; }
  const std::string& getNodeName() const { return _nodename; }

  void setDataServerName(const std::string& val) { _servername = val; }
  const std::string& getDataServerName() const { return _servername; }

  /**
   * When you want test reading a serial sensor.
   */
  void setSensorTestDevName(const std::string& val) { _sensorTestDevName = val; }
  const std::string& getSensorTestDevName() const { return _sensorTestDevName; }

  void addOpto22Relay(RelayProgram* relayProg, const std::string& devName);
#ifdef ENABLE_DSCUD
  void addIR104Relay(RelayProgram* relayProg, int ioAddr)
  	throw(atdUtil::IOException);
#endif

  void setArchiveValues(std::string& archiveDir,
		std::string& archiveFormat,
		int archiveLengthSecs);

  void createArchiver();

  void init() throw(atdUtil::IOException,atdUtil::UnknownHostException,
  	atdUtil::InvalidParameterException);

  static const std::string& getVersion();

  RawSampleSocket* getRawSampleSocket() const { return _rssocket; }
  RawSampleBuffer* getRawSampleBuffer() const { return _rsbuffer; }
  RawSampleArchiver* getRawSampleArchiver() const { return _archiver; }
  SensorPortHandler* getSensorPortHandler() const { return _sphandler; }
  ExtClockedA2DSampler* getA2DSampler() const { return _a2dsampler; }

#ifdef ENABLE_DSCUD
  Stepper* getStepper() { return _stepper; };
  void enableStepper()  { _dostepper = true; };
#endif

  void setA2D(A2D_t a, bool b, bool d) {
      a2d = a;
      bipolar = b;
      differential = d;
  }

  void setBuflenMsec(int val) 
  {
      buflenMsec = val;
  }

  int getNumSensors() const { return (int)_sensors.size(); }

  SensorPort* getSensor(unsigned int i) const {
    if (i < 0 || i >= _sensors.size()) return 0;
    return _sensors[i];
  }

  static int main(int argc, char **argv);
  static void usage(const char* argv0);

  void wait() throw(atdUtil::Exception);
  void interrupt();
  void quit();

  bool getQuit() const { return _quit; }

  time_t getStartTime() const { return _startTime; }
  time_t getRestartTime() const { return _restartTime; }

protected:

  NDaqSampler();

  void createRawSampleBuffer(int buflenMsec);
  void startSensorPortHandler();
  void setupSensorPorts() throw(atdUtil::UnknownHostException,atdUtil::IOException,atdUtil::InvalidParameterException);

  void createA2D() throw(atdUtil::IOException);
  void setupAnalogSampling() throw(atdUtil::UnknownHostException,atdUtil::IOException,atdUtil::InvalidParameterException);

  void startRelays() throw(atdUtil::IOException);

  const std::string _name;

  static const std::string _version;

  /**
   * Start time of main routine
   */
  static time_t _startTime;

  std::string _nodename;
  std::string _servername;
  std::string _sensorTestDevName;

  /**
   * Client that generates our output.
   */
  RawSampleClient* _rsoutput;

  /**
   * If _rsoutput is a RawSampleSocket, then
   * this is another pointer to the output RawSampleClient, else null.
   */
  RawSampleSocket* _rssocket;

  RawSampleBuffer* _rsbuffer;

  std::list<RawSampleClient*> _sensorClients;

  RawSampleArchiver* _archiver;
  SensorPortHandler* _sphandler;
  ExtClockedA2DSampler* _a2dsampler;
  DaqMonitorRPC* _monitor;
  std::vector<SensorPort*> _sensors;

  std::list<RelayProgram*> _relayPrograms;
  std::list<atdUtil::ThreadRunnable*> _relayThreads;
  std::list<Relay*> _relays;
  atdISFF::RrelayListener* _rrelayListener;
  SampleFormatter* _relayFormatter;

  TimerThread* _timer;

  bool _quit;

  /**
   * Start time of this Sampler.
   */
  time_t _restartTime;

  bool _privileged;

  std::string archiveDir;
  std::string archiveFormat;
  int archiveLengthSecs;

  /**
   * Which A2D to run.
   */
  enum A2Ds a2d;

  bool bipolar;
  
  bool differential;

  int buflenMsec;

#ifdef ENABLE_DSCUD
  /// True if we are supposed to create a stepper
  bool _dostepper;
  /// Points to the stepper controller, if we are using one.
  /// Otherwise, null.
  atdISFF::Stepper* _stepper;
#endif
};

}

#endif
