//
//              Copyright 2004 (C) by UCAR
//
// Description:
//
//

#ifndef ATDISFF_FIELDDATASOCKET_H
#define ATDISFF_FIELDDATASOCKET_H

#include <string>

// #include <iostream>
// #include <stdio.h>

#include <sys/socket.h>
#include <netinet/in.h>

#include <atdUtil/IOException.h>
#include <atdUtil/UnknownHostException.h>
#include <atdISFF/Time.h>

namespace atdISFF {

class FieldDataSocket {

public:
  FieldDataSocket(const std::string& host,int port);
  virtual ~FieldDataSocket();

  virtual void open() throw(atdUtil::UnknownHostException, atdUtil::IOException);
  virtual void close() throw(atdUtil::IOException);

  bool isConnected() const { return connected; }

  const char *getHostStringAddr() { return _hostStringAddr; }

  const std::string& getHostName() { return _hostname; }

  void setNonBlocking() throw (atdUtil::IOException);

  int  getSendBufferSize() throw (atdUtil::IOException);
  void setSendBufferSize(int size) throw (atdUtil::IOException);

  void setStatisticsPeriodInSecs(int val) { _statisticsPeriodMsec = val * 1000; }
  int getStatisticsPeriodInSecs() const { return _statisticsPeriodMsec / 1000; }

  void setMaxMilliSecondsBetweenWrites(int i);
  void setMinMilliSecondsBetweenWrites(int i);

  /**
   * What is the maximum size of record that I have written.
   */
  int getMaxWriteLength() const { return _maxWriteLength[_prevStatsIndex]; }

  /**
   * What is the minimum size of record that I have written.
   */
  int getMinWriteLength() const { return _minWriteLength[_prevStatsIndex]; }

  /**
   * What has been my throughput.
   */
  int getBytesPerSec() const;

  /**
   * return number of FieldDataSocket::writes (not number of socket writes)
   * per second.
   */
  float getWritesPerSec() const;

  /**
   * Number of write errors on the socket
   */
  int getNumWriteErrors() const { return _socketWriteErrors; }

  /**
   * Number of EAGAINs errors on writes to a non-blocking socket. These
   * are not hard errors.
   */
  int getNumWriteTempUnavailable() const { return _socketTempUnavailable; }

  /**
   * Number of EINTR errors on writes.
   */
  int getNumWriteInterrupted() const { return _socketInterrupted; }

  /**
   * All or nothing. Either the sample was buffered up for writing
   * or it wasn't.
   */
  bool write(const char * const*buf,int *len,int nbuf) throw (atdUtil::IOException);

  std::string getName();

protected:

  int _fd;

  char _hostStringAddr[INET_ADDRSTRLEN];
  std::string _hostname;

  int _port;
  struct sockaddr_in _hostAddr;

  int _bufsize;
  int _writelen;

  /* pointers to beginning of buffers */
  char *_bufs[2];

  /* for input buffer, where to place next data */
  /*
    for output buffer, where to write from next time

    If bufPtrs[outbuf] < bufs[outbuf] + bufN[outbuf] then
    we haven't completely written the output buffer.
  */
  char *_bufPtrs[2];

  /* how many bytes in each buffer */
  int _bufN[2];

  /* initial index to input buffer */
  int _inbuf;
  int _outbuf;

  int _statisticsPeriodMsec;

  isff_sys_time_t _statisticsTime;

/* Solaris 2.6 */
#ifndef INET_ADDRSTRLEN
#define INET_ADDRSTRLEN 256
#endif

  int _currStatsIndex;
  int _prevStatsIndex;

  /* number of partial writes in last statistics period */
  int _partialWrites[2];	// for current and previous period

  /* maximum successful write to socket */
  int _maxWriteLength[2];

  /* minimum successful write to socket */
  int _minWriteLength[2];

  /* number of kbytes written */
  size_t _socketBytes[2];

  /* number of FieldDataSocket::writes (not number of system writes) */
  size_t _numWrites[2];

  /* number of write errors */
  int _socketWriteErrors;

  /* number of EAGAIN occurences writing to non-blocking socket */
  int _socketTempUnavailable;

  /* number of EINTR occurences writing to non-blocking socket */
  int _socketInterrupted;

  /** maximum number of seconds between buffered writes */
  int _maxMilliSeconds;

  /** minimum number of seconds between buffered writes */
  int _minMilliSeconds;

  time_t _startupTime;
  isff_sys_time_t _lastWrite;

  void initBuffers();
  void createBuffers() throw(atdUtil::IOException);
  void deleteBuffers();

  void zeroStatistics();
  void resetStatistics(isff_sys_time_t);

  bool connected;

};

}

#endif
