//
//              Copyright 2004 (C) by UCAR
//


#ifndef ATDISFF_EXTCLOCKEDA2DSAMPLER_H
#define ATDISFF_EXTCLOCKEDA2DSAMPLER_H

#include <atdISFF/A2DSampler.h>

namespace atdISFF {

/**
 * A free-running A2DSampler, meaning one sets it up
 * and an external clock drives the sampling.
 */
class ExtClockedA2DSampler : public virtual A2DSampler {
public:

  ExtClockedA2DSampler(const std::string& name) :
  	A2DSampler(name) {}

  virtual const std::vector<float>& getAvailableSamplingRates() const = 0;

  virtual void addChannel(int num, int samplingRateIndex,
  	int voltageRangeIndex) throw(atdUtil::IOException,atdUtil::InvalidParameterException) = 0;

protected:

};

}

#endif
