#include <atdISFF/daqmonitor.h>
#include <atdISFF/DaqMotor.h>
#include <iostream>
#include <iomanip>

using namespace std;
using namespace atdISFF;

//---------------------------------------------------------------
DaqMotor::DaqMotor(std::string host):
  _host(host)
{
}

//---------------------------------------------------------------
DaqMotor::~DaqMotor() {
}

//---------------------------------------------------------------
bool
DaqMotor::status(int motorNumber,
		 atdISFF::Stepper::StepperStatus& status, 
		 double& position) {
  int rpcStatus =  daqMotorCall(motorNumber,
				atdISFF::Stepper::STEPPERCMD_STATUS, 
				0);
  status   = _status;
  position = _position;
  return rpcStatus;
}

//---------------------------------------------------------------
bool
DaqMotor::zero(int motorNumber) {
  return daqMotorCall(motorNumber,
		      atdISFF::Stepper::STEPPERCMD_ZERO, 
		      0);
}

//---------------------------------------------------------------
bool
DaqMotor::reset(int motorNumber) {
  return daqMotorCall(motorNumber,
		      atdISFF::Stepper::STEPPERCMD_RESET, 
		      0);
}

//---------------------------------------------------------------
bool
DaqMotor::move(int motorNumber,
	       double steps) {
  return daqMotorCall(motorNumber,
		      atdISFF::Stepper::STEPPERCMD_MOVE, 
		      steps);
}
//---------------------------------------------------------------
bool
DaqMotor::daqMotorCall(int motorNumber,
		       atdISFF::Stepper::StepperCommand cmd, 
		       double arg)
{
  bool cmdStatus = true;
  CLIENT *cl;
  daqMotor_res* res;
  struct daqMotorCmd motorCommand;

  motorCommand.motorNumber = motorNumber;
  motorCommand.command = cmd;
  motorCommand.arg1 = arg;

  cl = clnt_create(_host.c_str(),DAQMONITOR_PROG,DAQMONITOR_VERS,"udp");
 
  if (cl == NULL) {
    clnt_pcreateerror(_host.c_str());
    return false;
  }
 
  res = daqmotor_1(motorCommand, cl);

  if (res == NULL) {
    clnt_perror(cl,_host.c_str());
    clnt_destroy(cl);
    return false;
  }
  clnt_destroy(cl);
 
  if (res->ierr) {
    cerr << "error=" << res->daqMotor_res_u.errmsg << endl;
    cmdStatus = false;
  } else {
    _status   = (atdISFF::Stepper::StepperStatus)res->daqMotor_res_u.status.status;
    _position = res->daqMotor_res_u.status.position;
    cmdStatus = true;
  }

  xdr_free((bool_t(*)(XDR*,void*,...))xdr_void,(char *)res);
  return cmdStatus;
}

