
/*              Copyright 2004 (C) by UCAR
 *
 * File       : DaqMonitorRPC.h,v
 * Revision   : 1.9
 * Directory  : /code/cvs/isa/src/lib/atdISFF/DaqMonitorRPC.h,v
 * System     : PAM
 * Date       : 2006/01/28 23:12:03
 *
 * Description:
 *   Class containing information (error counters, event counters, sample rates)
 *   about the status of the data acquisition system
 *
 * DaqMonitorRPC.h,v
 * Revision 1.9  2006/01/28 23:12:03  maclean
 * more fiddles for non-dscud builds
 *
 * Revision 1.8  2006/01/28 22:27:53  maclean
 * changes so that things build if not using Diamond System universal driver
 *
 * Revision 1.7  2006/01/28 03:45:03  martinc
 * completely reworked to place stepper functions in a thread so that they wdo not block the rpc handling in DaqMonitorRPC.
 *
 * Revision 1.6  2006/01/26 04:57:43  martinc
 * major refactoring of motor control. Created Stepper class for instatiating a motor on ndaq, and DaqMotor class for the remote manifestation of the Stepper. Stepper is created by DaqMonitor. The motor rpc calls are forwarded onto Stepper.
 *
 * Revision 1.5  2006/01/25 20:13:41  martinc
 * Added parameter passing for daqMotor_1_svc
 *
 * Revision 1.4  2006/01/25 05:39:08  martinc
 * Added stub for motor control RPC.
 *
 * Revision 1.3  2005/01/16 01:34:21  maclean
 * added copyright
 *
 * Revision 1.2  2004/05/25 16:45:01  maclean
 * Initial version for Brit Stephens, OHATS test
 *
 * Revision 1.1.1.1  2004/03/18 14:49:51  maclean
 * first import
 *
 */

#ifndef ATDISFF_DAQMONITORRPC_H
#define ATDISFF_DAQMONITORRPC_H

#include <config.h>

#include <atdISFF/daqmonitor.h>
#ifdef ENABLE_DSCUD
#include <atdISFF/Stepper.h>
#endif
#include <atdUtil/Thread.h>
#include <atdUtil/IOException.h>

namespace atdISFF {

  class DaqMonitorRPC : public atdUtil::Thread {

  protected:

    static DaqMonitorRPC* _instance;
    DaqMonitorRPC() throw(atdUtil::IOException);

  public:

    static DaqMonitorRPC* createInstance() throw(atdUtil::IOException);

    ~DaqMonitorRPC();

    static DaqMonitorRPC* getInstance() { return _instance; }

    int run() throw(atdUtil::Exception);

    daqStatus_res* doStatus();
    void* doRestart();
    void* doStop();
#ifdef ENABLE_DSCUD
    daqMotor_res* doMotor(daqMotorCmd*);
#endif

  protected:

    SVCXPRT* _udptransport;
    SVCXPRT* _tcptransport;

    /// The current motor position
    double _currentMotorPosition;
    /// The current motor status
    int _motorStatus;
  };
}

extern "C" {
  daqStatus_res* daqstatus_1_svc(struct svc_req* req);
#ifdef ENABLE_DSCUD
  daqMotor_res*  daqmotor_1_svc(daqMotorCmd cmd, struct svc_req* req);
#endif
}

#endif
