
/*              Copyright 2004 (C) by UCAR
 *
 * File       : BinarySensorPort.h,v
 * Revision   : 1.6
 * Directory  : /code/cvs/isa/src/lib/atdISFF/BinarySensorPort.h,v
 * System     : PAM
 * Date       : 2005/11/16 18:17:48
 *
 * Description:
 *
 * BinarySensorPort.h,v
 * Revision 1.6  2005/11/16 18:17:48  maclean
 * fixed a bunch of compiler warnings
 *
 * Revision 1.5  2005/01/16 01:34:20  maclean
 * added copyright
 *
 * Revision 1.4  2004/06/23 14:25:27  maclean
 * reorg. Added RawSampleClient and RawSampleSource, and a source can have multiple clients
 *
 * Revision 1.3  2004/05/25 16:45:01  maclean
 * Initial version for Brit Stephens, OHATS test
 *
 * Revision 1.2  2004/04/27 16:43:32  maclean
 * *** empty log message ***
 *
 * Revision 1.1.1.1  2004/03/18 14:49:51  maclean
 * first import
 *
 */

#ifndef ATDISFF_BINARYSENSORPORT_H
#define ATDISFF_BINARYSENSORPORT_H

#include <atdUtil/IOException.h>
#include <atdISFF/SensorPort.h>

namespace atdISFF {
class BinarySensorPort : public SensorPort {

public:
  BinarySensorPort(const std::string portName,int channel)
  	throw (atdUtil::IOException);
  ~BinarySensorPort();

  void setMessageLength(int val);
  void setMessageSeparator(const std::string& val)
  	throw(atdUtil::IOException);

  virtual void init() throw(atdUtil::IOException);

  void processInput(isff_sys_time_t time, const char *charP)
	throw(atdUtil::IOException);

protected:
  int currentSampleLen;
  char* syncstr;
  int lsync;
  int nsync;

  void setDefaultSampleDeltaTmsec();

  void scanInputSepAtBOM(const char *charP);
  void scanInputSepAtEOM(const char *charP);

};
}

#endif

