//
//              Copyright 2004 (C) by UCAR
//

#include <atdISFF/AsciiSensorPort.h>
#include <atdISFF/RawSample.h>

using namespace atdISFF;
using namespace atdUtil;
using namespace std;

AsciiSensorPort::AsciiSensorPort(const std::string portName,int channel)
  throw (atdUtil::IOException) :SensorPort(portName,channel)
{
  setMessageSeparator(string(1,'\n'));
}

void AsciiSensorPort::init() throw(atdUtil::IOException) {
  SensorPort::init();
  scanPtr = buffer;
}

void AsciiSensorPort::setMessageSeparator(const std::string& val)
	throw (IOException) {
  SensorPort::setMessageSeparator(val);
  if (val.size() != 1) throw IOException(getName(),
  	"setMessageSeparator",
	"message separator for AsciiSensorPort must be one character");
  eom = val[0];
}

/**
 * Scan buffer for one or more samples. Return a list of
 * pointers to those samples and an approximation of
 * the transmission time of the first sample.
 */
isff_sys_time_t AsciiSensorPort::scanForSamples(isff_sys_time_t rtime,const char *charP)
{

  deltatms = 0.0;
  register const char *cp = charP;
  
  for (;;) {
    // scan for eom
    for(; cp < eodP && *cp != eom; cp++);
    if (cp == eodP) break;      // no eom found
    samplePointers.push_back(scanPtr);
    cp++;       // one past eom, first char in next sample, may be eodP
    scanPtr = cp;
  }

  // samplePointers is a vector of pointers to the beginning of
  // complete samples (those terminated with an eom).
  // scanPtr is now either eodP or points to the
  // beginning of a partial sample at the end of the buffer

  size_t nsamp = samplePointers.size();

  // number of bytes from beginning of last partial sample to end of read
  int len = eodP - scanPtr;
  bool lastIsPartial = len > 0;

  int nsampDt = nsamp;
  if (!lastIsPartial) {			// last is complete sample
    list<const char*>::const_iterator spitr = samplePointers.end();
    spitr--;	// last sample pointer
    len = eodP - *spitr;			// len of last sample
    nsampDt--;				// how many sample dTs to roll back
  }

  /* Compute time of first byte of last sample, which
   * may be a partial sample. Assume characters
   * are evenly spaced at msecsPerChar apart.
   */
  rtime = isff_sys_time_add(rtime,-(len * msecsPerChar));

  if (nsampDt > 0) {
    // since we have to roll rtime back over one or more samples
    // we need to know the sample deltat.  We compute that
    // from the last sample time in the previous buffer.
    // compute how many deltaT's back to that sample.
    if (lastSampleTime == 0) {
      // if we have no last sample then we don't know the deltat.
      // So we have to toss them all except possibly the last one
      // if the last bytes in the the buffer are a complete
      // sample (lastIsPartial == false).

      for (int i = 0; i < nsampDt; i++)
        samplePointers.erase(samplePointers.begin());
      lastSampleTime = rtime;
    }
    else {
      int ndt = nsamp;
      if (lastIsPartial) ndt++;
      if (partialLastSample) ndt--;
      deltatms = (double)(rtime - lastSampleTime) / ndt;
      /* deltatms can be negative if the system clock
       * is reset backwards - by user or ntp.
       */
      if (deltatms < 0.0) deltatms = 0.0;
      // cerr << "chan=" << getChannel() << " deltatms=" << deltatms << " ndt=" << ndt << " nsamp=" << nsamp << endl;

      lastSampleTime = rtime;

      /* Compute time of initial sample */
      rtime = isff_sys_time_add(rtime,-(nsampDt * deltatms));
    }
  }
  else lastSampleTime = rtime;		// nsampDt == 0
  partialLastSample = lastIsPartial;

  return rtime;
}
void AsciiSensorPort::processInput(isff_sys_time_t rtime,const char *charP)
	throw(IOException)
{
  rtime = scanForSamples(rtime,charP);

  if (samplePointers.size() > 0) {
    list<const char*>::const_iterator spitr = samplePointers.begin();
    list<const char*>::const_iterator spend = samplePointers.end();
    const char* p1 = *spitr;
    const char* p2;
    int is = 0;
    int len;
    for (; spitr != spend; ) {
      spitr++;
      if (spitr == spend) p2 = scanPtr;
      else p2 = *spitr;
      len = p2 - p1 - 1;	// one character EOM

      RawSample *sample = 
	      RawSamplePool::getInstance()->getRawSample(len);

      sample->tt = sample_time(rtime,(is++ * deltatms));
      sample->chan = chan;
      sample->len = (unsigned char) len;
      ::memcpy(sample->data,p1,len);
      distribute(sample);
      nsamples++;
      p1 = p2;
    }
  }
  shiftBuffer();
}

