//
//              Copyright 2004 (C) by UCAR
//

#include <atdISFF/AsciiSampleArchiver.h>
#include <atdUtil/Logger.h>

#include <stdio.h>

using namespace atdISFF;
using namespace atdUtil;
using namespace std;

AsciiSampleArchiver::AsciiSampleArchiver() : RawSampleArchiver()
{
}

AsciiSampleArchiver::~AsciiSampleArchiver()
{
}

void AsciiSampleArchiver::write(isff_sys_time_t fullTT,
    const RawSample* samp) throw(IOException)
{
  // don't write 0 length samples
  if (samp->len == 0) return;

  // since we do not keep the sample, no need to samp->holdReference()

  float t = samp->tt / 1000.;

  ::fprintf(cfp,"%7.1f ",t);

  int len = samp->len;
  if (len > 0 && samp->data[len-1] == '\0') len--;

  if (::fwrite(samp->data,len,1,cfp) < 1 && ferror(cfp))
      	throw IOException(fileName,"write",errno);
  ::fprintf(cfp,"\r\n");
}
