//
//              Copyright 2004 (C) by UCAR
//

#include <atdISFF/AsciiRawSampleOutputStream.h>

#include <iomanip>

using namespace atdISFF;
using namespace std;

AsciiRawSampleOutputStream::AsciiRawSampleOutputStream(std::ostream& ostr) :
	RawSampleOutputStream(ostr) {}

bool AsciiRawSampleOutputStream::receive(const RawSample *sample) throw(atdUtil::IOException) {
  long tmpTime = sample->tt;
  int hr = tmpTime / 3600000;
  tmpTime %= 3600000;
  int min = tmpTime / 60000;
  tmpTime %= 60000;
  float sec = tmpTime / 1000.0f;

  ost << setw(2) << setfill('0') << hr << ':' << 
	setw(2) << min << ':' << 
	setw(4) << fixed << setprecision(1) << sec <<
	// setw(8) << setfill(' ') << sample->tt / 1000.0 << ' ' <<
	' ' <<
	(char*) sample->data << std::endl;
  return true;
}
