#!/bin/bash

#--- input file
fltnm=${1}

#--- output directory (local)
outdir=${DATAROOT}/orcas/fltpln-out

#--- remote machine set web machine (set to empty if local)
webmach=yellowstone.ucar.edu  # remote machine
webdir=/glade/p/work/mclong/orcas/fltpln-out
upload=1


#------------------------------------------------
#--- END USER INPUT
#------------------------------------------------
#--- make sure R is available
type R > /dev/null
if [ $? -ne 0 ]; then
    type module > /dev/null
    if [ $? -ne 0 ]; then
	echo "R not found."
	exit 1
    else
	module load R
    fi
fi

#--- pick mode
if [ -z "${webmach}" ]; then
    mode=local
else
    mode=remote
fi

#--- all my flights?
if [[ "${fltnm}" == "ALL" ]]; then
    echo "Running all flights"

    echo "Wipe web directory? (y/n)"
    read yn

    if [[ "${yn}" == "y" ]]; then
	case "${mode}" in
	    "remote") ssh ${webmach} rm -f ${webdir}/* ;;
	    "local")  rm -fr ${webdir}/* ;;
	esac
	rm -fr ${outdir}/*
    fi
    fltlst=$(cat flight_plan_list.txt)
else
    fltlst=(${fltnm})
fi

#--- make output directory if necessary
if [ ! -d ${outdir} ]; then mkdir -p ${outdir}; fi

#--- loop over flights
for fltnm in ${fltlst[@]}; do
    #--- strip extension
    nm=$(basename ${fltnm} .txt)

    if [ ! -f ${nm}.txt ]; then
	echo "${nm}.txt not found."
	exit 1
    fi

    #--- run prog
    R -q -e "source('fpnn.r'); fpnn(flightname='${nm}',netdir='${outdir}');"
    if [ $? -ne 0 ]; then echo "it barfed.  good luck."; exit 1; fi

done

#--- put stuff where it belongs
if [[ "${mode}" == "remote" ]]; then
    if [ ${upload} -eq 1 ]; then
	rsync -av --delete --progress ${outdir}/ ${webmach}:${webdir}
    else
	open ${outdir}/index.html
    fi
elif [[ "${outdir}" != "${webdir}" ]]; then
    cp -vpr ${outdir}/* ${webdir}
fi

echo "done."


