"""
Input file for flight line planning program
  There are two inputs to define:
    prj: is an object define the UTM projection and
         has the following default attributes.

        prj.centereast: 433820.404
        prj.centernorth: 2798242.817
        prj.angle: -0.872664625997
        prj.zone: -20.0

  Any of these can be replaced below.

    fly: is an object with the specification of the flight
         plan.

        fly.turn_x_km: 41      # 1.852(km/nm)*22(nm) ~ 40 km
        fly.spcng: 5.75        # 1.852(km/nm)*3.(nm) ~ 6 km
        fly.alt: 41000         # altitude
        fly.nlines: 6          # number of lines (must be even)
        fly.east_km: [290, 70] # Y limits of lines
        fly.north_km_0: 610    # starting line (grid X)

"""

#---------------------------------
#--- projection settings
#--- set the zone
prj.zone = -20.

#--- center the  UTM grid on lat/lon point (grid center)
xc,yc = geo2utm(-54.,-60.,prj) # lat,lon,projection
prj.centernorth = yc
prj.centereast  = xc

#--- rotate the grid
prj.angle = -70.

#---------------------------------
#--- lay the lines
fly.north_km_0 = 900.
fly.east_km = [650,200]
fly.nlines = 9
