#include <config.h>
#include <ucd-snmp-config.h>
#ifdef HAVE_NETINET_IN_H
#include <netinet/in.h>
#endif
#include <ucd-snmp-includes.h>
#include <snmp_agent.h>
#include <snmp_vars.h>
#include <ds_agent.h>
#include <var_struct.h>
#include <agent_read_config.h>

#include "aj_command.h"
#include "aj_gpio.h"
#include "aj_serial.h"
#include "aj_misc.h"

int main (int argc, char* argv[]) {
  if(argc > 1){
  	ds_set_string(DS_LIBRARY_ID, DS_LIB_OPTIONALCONFIG, argv[1]);
    ds_set_boolean(DS_LIBRARY_ID, DS_LIB_DONT_READ_CONFIGS, 1);
  }

  /* initialize the agent library */
  init_agent("aj_snmp");
//  init_mib_modules();

  /* initialize your mib code here */
  init_aj_command();
  init_aj_serial();
  init_aj_gpio();
  init_aj_misc();

  init_snmp("aj_snmp");

  /* If we're going to be a snmp master agent */
  init_master_agent( 161, NULL, NULL );  /* open port 161 (UDP:snmp) */

  /* you're main loop here... */
  while(1) {
    agent_check_and_process(1); /* 0 == don't block */
  }

  snmp_shutdown("aj_snmp");
}
