
#include <stdio.h> 
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#define LED_DEV "/dev/ajled"

#define LOG_MSG(args...) printf(args)

static void usage(void){
  printf("Usage : ledctrl [ACTION]\n");
  printf("  ACTION\n");
  printf("     \"on\"  , \"ON\"    : LED on\n");
  printf("     \"off\" , \"OFF\"   : LED off\n");
  printf("     \"read\" , \"READ\" : Status read\n");
}

int main(int argc,char **argv){
  int fd;
  char buf[8];
  
  if(argc<=1){
    usage();
    return 1;
  }
  
  if((fd=open(LED_DEV,O_RDWR))==0){
    LOG_MSG("Not found device : %s\n",LED_DEV);
    return 1;
  }
  
  if(
     (memcmp(argv[1],"on",2)==0 && strlen(argv[1])==2) || 
     (memcmp(argv[1],"ON",2)==0 && strlen(argv[1])==2)
     ){
    write(fd,"ON",2);
  }else if(
	   (memcmp(argv[1],"off",3)==0 && strlen(argv[1])==3) ||
	   (memcmp(argv[1],"OFF",3)==0 && strlen(argv[1])==3)
	   ){
    write(fd,"OFF",3);
  }else if(
	   (memcmp(argv[1],"read",4)==0 && strlen(argv[1])==4) ||
	   (memcmp(argv[1],"READ",4)==0 && strlen(argv[1])==4)
	   ){
    read(fd,buf,8);
    printf("LED Status : %s\n",buf);
  }else{
    usage();
  }

  close(fd);
  return 0;
}
     

