/* $Id: linux_logo.h,v 1.1.1.1 2004/02/12 02:58:45 nakano Exp $
 * include/asm-m68k/linux_logo.h: This is a linux logo
 *                                 to be displayed on boot.
 *
 * Copyright (C) 1996 Larry Ewing (lewing@isc.tamu.edu)
 * Copyright (C) 1996 Jakub Jelinek (jj@sunsite.mff.cuni.cz)
 *
 * You can put anything here, but:
 * LINUX_LOGO_COLORS has to be less than 224
 * image size has to be 80x80
 * values have to start from 0x20
 * (i.e. RGB(linux_logo_red[0],
 *	     linux_logo_green[0],
 *	     linux_logo_blue[0]) is color 0x20)
 * BW image has to be 80x80 as well, with MS bit
 * on the left
 * Serial_console ascii image can be any size,
 * but should contain %s to display the version
 */
 
#include <linux/config.h>
#include <linux/init.h>
#include <linux/version.h>

#define linux_logo_banner "Linux/m68k version " UTS_RELEASE

#ifdef CONFIG_MAC

#define __HAVE_ARCH_LINUX_LOGO

#define LINUX_LOGO_COLORS	185

#ifdef INCLUDE_LINUX_LOGO_DATA

unsigned char linux_logo_red[] __initdata = {
    0x00, 0x06, 0x0a, 0x0e, 0x16, 0x1a, 0x1e, 0x22,
    0x12, 0x00, 0x2a, 0x36, 0x42, 0x4e, 0x4a, 0x56,
    0x26, 0x46, 0x2e, 0x32, 0x52, 0x3a, 0x02, 0xfa,
    0xf2, 0xf6, 0xe7, 0x74, 0x65, 0x7b, 0xea, 0xdd,
    0xd6, 0x5e, 0xbe, 0x5a, 0xe2, 0xda, 0xee, 0xb6,
    0xce, 0x65, 0x6e, 0x6a, 0xd2, 0xc6, 0x90, 0xca,
    0x9e, 0xbb, 0xb2, 0x8a, 0xa2, 0x9a, 0x86, 0xc3,
    0xfd, 0xae, 0x3e, 0xaa, 0x95, 0x80, 0x76, 0x79,
    0x62, 0x36, 0x9a, 0xe2, 0xec, 0xe1, 0xb8, 0xd7,
    0xaf, 0x25, 0xbc, 0xc0, 0xef, 0xea, 0xe8, 0xe8,
    0xf5, 0xf1, 0xda, 0xd3, 0x79, 0xdb, 0xf4, 0xf6,
    0xf6, 0xf6, 0xe2, 0x3d, 0xb4, 0xce, 0xe6, 0xee,
    0xf6, 0xa6, 0x68, 0xd8, 0xec, 0xf5, 0xc6, 0xc8,
    0x9c, 0x89, 0xd2, 0xee, 0xcb, 0xb9, 0xd2, 0x66,
    0x5e, 0x8b, 0xbe, 0xa8, 0xd5, 0xca, 0xb6, 0xae,
    0x9c, 0xc5, 0x8d, 0xbe, 0xbe, 0xb2, 0x9a, 0xa8,
    0x16, 0x12, 0x4a, 0x8e, 0xf2, 0xf6, 0xe4, 0xf1,
    0x26, 0x9a, 0xea, 0xf6, 0xe0, 0xd2, 0x9a, 0x2e,
    0x70, 0xd6, 0x46, 0x7c, 0xb4, 0x62, 0xd6, 0xa3,
    0x74, 0xa7, 0xa2, 0xca, 0xe0, 0xae, 0xbe, 0xce,
    0xa3, 0x8e, 0x6d, 0x8e, 0x32, 0xaf, 0x50, 0x9e,
    0x5b, 0x8a, 0x98, 0x82, 0x7a, 0x82, 0x56, 0x7c,
    0x8a, 0x56, 0x5e, 0x86, 0x6a, 0x52, 0x59, 0x64,
    0x5e,
};

unsigned char linux_logo_green[] __initdata = {
    0x00, 0x06, 0x0a, 0x0e, 0x16, 0x1a, 0x1e, 0x22,
    0x12, 0x00, 0x2a, 0x36, 0x42, 0x4e, 0x4a, 0x56,
    0x26, 0x46, 0x2e, 0x32, 0x52, 0x3a, 0x02, 0xfa,
    0xf2, 0xf6, 0xe7, 0x74, 0x65, 0x7b, 0xea, 0xdd,
    0xd6, 0x5e, 0xbe, 0x5a, 0xe2, 0xda, 0xee, 0xb6,
    0xce, 0x62, 0x6e, 0x6a, 0xd2, 0xc6, 0x90, 0xca,
    0x9e, 0xbb, 0xb2, 0x8a, 0xa2, 0x9a, 0x86, 0xc3,
    0xfd, 0xae, 0x3e, 0xaa, 0x95, 0x80, 0x62, 0x5c,
    0x4e, 0x26, 0x72, 0xaa, 0xba, 0xaf, 0x90, 0xae,
    0x92, 0x1a, 0xa4, 0x85, 0xb6, 0xbe, 0xc3, 0xc8,
    0xcf, 0xd0, 0xc2, 0xce, 0x57, 0xa2, 0xd6, 0xda,
    0xda, 0xd7, 0xb8, 0x2a, 0x7b, 0x91, 0xae, 0xca,
    0xda, 0xa6, 0x45, 0x9e, 0xb2, 0xd7, 0x9b, 0x90,
    0x76, 0x5c, 0xa2, 0xbe, 0xa6, 0x85, 0x96, 0x4e,
    0x46, 0x66, 0x92, 0x7a, 0x9a, 0x96, 0x9d, 0x9a,
    0x6b, 0x8a, 0x8d, 0x8e, 0xb2, 0xa6, 0x79, 0x7c,
    0x12, 0x0e, 0x36, 0x86, 0xba, 0xbe, 0xb8, 0xc4,
    0x1e, 0x8e, 0xae, 0xba, 0xb2, 0xa6, 0x7a, 0x20,
    0x64, 0xaa, 0x2f, 0x70, 0x85, 0x46, 0xa6, 0x6e,
    0x51, 0x72, 0x92, 0xa2, 0xa6, 0x87, 0x96, 0xa2,
    0x85, 0x7a, 0x6a, 0x6e, 0x22, 0x76, 0x36, 0x76,
    0x3c, 0x6e, 0x63, 0x53, 0x66, 0x62, 0x42, 0x50,
    0x56, 0x42, 0x56, 0x56, 0x56, 0x3e, 0x51, 0x52,
    0x56,
};

unsigned char linux_logo_blue[] __initdata = {
    0x00, 0x06, 0x0a, 0x0e, 0x16, 0x1a, 0x1e, 0x22,
    0x12, 0x01, 0x2a, 0x36, 0x42, 0x4e, 0x4a, 0x56,
    0x26, 0x46, 0x2e, 0x32, 0x52, 0x3a, 0x06, 0xfa,
    0xf2, 0xf6, 0xe7, 0x74, 0x65, 0x7b, 0xea, 0xdd,
    0xd6, 0x5e, 0xbe, 0x5a, 0xe2, 0xda, 0xee, 0xb6,
    0xce, 0x59, 0x6e, 0x6a, 0xd2, 0xc6, 0x90, 0xca,
    0x9e, 0xbb, 0xb2, 0x8a, 0xa2, 0x9a, 0x86, 0xc3,
    0xfd, 0xae, 0x3e, 0xaa, 0x95, 0x80, 0x2e, 0x08,
    0x0a, 0x06, 0x0a, 0x0b, 0x0b, 0x0f, 0x0c, 0x0f,
    0x3d, 0x09, 0x73, 0x09, 0x0d, 0x0a, 0x10, 0x1e,
    0x2d, 0x13, 0x86, 0xba, 0x19, 0x0a, 0x36, 0x3c,
    0x26, 0x14, 0x0d, 0x06, 0x07, 0x0a, 0x0b, 0x0f,
    0x4a, 0xa6, 0x06, 0x0a, 0x0c, 0x2b, 0x0a, 0x0b,
    0x0a, 0x06, 0x0a, 0x0a, 0x11, 0x0b, 0x0a, 0x0a,
    0x1e, 0x0f, 0x0d, 0x0a, 0x0b, 0x22, 0x6a, 0x72,
    0x0b, 0x0b, 0x8d, 0x22, 0x90, 0x92, 0x3c, 0x2c,
    0x06, 0x06, 0x0e, 0x6a, 0x0e, 0x0e, 0x3e, 0x0e,
    0x0a, 0x5a, 0x0d, 0x0e, 0x3e, 0x0a, 0x2e, 0x06,
    0x4e, 0x36, 0x06, 0x58, 0x24, 0x06, 0x3a, 0x08,
    0x08, 0x07, 0x5e, 0x45, 0x0a, 0x32, 0x2e, 0x2a,
    0x43, 0x48, 0x5f, 0x2e, 0x06, 0x06, 0x07, 0x24,
    0x06, 0x32, 0x06, 0x06, 0x46, 0x2e, 0x22, 0x06,
    0x06, 0x1e, 0x4c, 0x06, 0x3a, 0x22, 0x42, 0x34,
    0x42,
};

unsigned char linux_logo[] __initdata = {
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x21, 0x21, 0x22, 0x22,
    0x22, 0x21, 0x21, 0x21, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27,
    0x26, 0x26, 0x25, 0x28, 0x23, 0x22, 0x21, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x29, 0x29, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x21, 0x23, 0x25, 0x2a, 0x2b, 0x2c, 0x2d, 0x2d,
    0x2d, 0x2e, 0x2c, 0x2b, 0x2a, 0x25, 0x28, 0x22,
    0x21, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x29, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x22,
    0x24, 0x2a, 0x2c, 0x2f, 0x2c, 0x30, 0x30, 0x24,
    0x25, 0x27, 0x2b, 0x2c, 0x2f, 0x31, 0x32, 0x25,
    0x23, 0x21, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x29, 0x29, 0x29, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x22, 0x25,
    0x33, 0x34, 0x35, 0x21, 0x36, 0x36, 0x36, 0x36,
    0x36, 0x36, 0x36, 0x36, 0x21, 0x2b, 0x2f, 0x2c,
    0x30, 0x28, 0x21, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x21, 0x24, 0x33,
    0x2d, 0x27, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36,
    0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x21, 0x31,
    0x2d, 0x32, 0x24, 0x21, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x29, 0x29, 0x29, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x37, 0x37, 0x37, 0x37, 0x38,
    0x37, 0x37, 0x39, 0x37, 0x39, 0x38, 0x39, 0x3a,
    0x32, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36,
    0x36, 0x36, 0x36, 0x23, 0x32, 0x27, 0x21, 0x36,
    0x34, 0x38, 0x38, 0x39, 0x38, 0x37, 0x38, 0x39,
    0x38, 0x37, 0x38, 0x37, 0x37, 0x37, 0x37, 0x37,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x29, 0x20, 0x29, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x38, 0x37, 0x37, 0x37, 0x37,
    0x38, 0x39, 0x37, 0x37, 0x37, 0x37, 0x38, 0x3b,
    0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36,
    0x36, 0x36, 0x36, 0x25, 0x2f, 0x3c, 0x32, 0x22,
    0x36, 0x3d, 0x38, 0x37, 0x39, 0x37, 0x38, 0x37,
    0x39, 0x37, 0x38, 0x37, 0x38, 0x37, 0x37, 0x37,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x29, 0x29, 0x29, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x3d, 0x3e, 0x3a, 0x3e, 0x3e,
    0x3e, 0x3f, 0x3e, 0x3a, 0x3e, 0x3e, 0x40, 0x22,
    0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36,
    0x36, 0x36, 0x36, 0x26, 0x41, 0x41, 0x35, 0x25,
    0x36, 0x22, 0x42, 0x38, 0x38, 0x37, 0x37, 0x38,
    0x39, 0x37, 0x37, 0x38, 0x37, 0x38, 0x38, 0x3a,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x43, 0x3e, 0x44, 0x44, 0x45,
    0x44, 0x40, 0x3a, 0x3f, 0x3a, 0x3f, 0x3b, 0x36,
    0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36,
    0x36, 0x36, 0x36, 0x25, 0x2b, 0x30, 0x28, 0x22,
    0x36, 0x36, 0x35, 0x38, 0x38, 0x38, 0x38, 0x38,
    0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x37, 0x44,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x29, 0x29, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x34, 0x3e, 0x3a, 0x38, 0x38,
    0x3e, 0x3e, 0x46, 0x3e, 0x46, 0x46, 0x33, 0x36,
    0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36,
    0x36, 0x36, 0x36, 0x22, 0x22, 0x36, 0x36, 0x36,
    0x36, 0x36, 0x36, 0x47, 0x38, 0x37, 0x37, 0x37,
    0x38, 0x37, 0x37, 0x37, 0x38, 0x38, 0x37, 0x48,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x29, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x33, 0x37, 0x44, 0x3e, 0x22,
    0x2d, 0x2c, 0x49, 0x43, 0x4a, 0x4b, 0x22, 0x36,
    0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36,
    0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36,
    0x36, 0x36, 0x36, 0x49, 0x4c, 0x46, 0x44, 0x46,
    0x4c, 0x38, 0x44, 0x38, 0x38, 0x3e, 0x37, 0x4d,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x29, 0x29, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x34, 0x3e, 0x3e, 0x3a, 0x36,
    0x20, 0x20, 0x20, 0x23, 0x2a, 0x34, 0x36, 0x36,
    0x36, 0x21, 0x22, 0x36, 0x36, 0x36, 0x36, 0x36,
    0x36, 0x36, 0x36, 0x21, 0x23, 0x22, 0x36, 0x36,
    0x36, 0x36, 0x36, 0x28, 0x34, 0x27, 0x22, 0x20,
    0x21, 0x20, 0x20, 0x20, 0x4e, 0x37, 0x38, 0x4f,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x29, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x34, 0x44, 0x3a, 0x3e, 0x43,
    0x20, 0x20, 0x20, 0x23, 0x32, 0x2f, 0x36, 0x36,
    0x21, 0x21, 0x24, 0x27, 0x21, 0x36, 0x36, 0x36,
    0x36, 0x36, 0x28, 0x27, 0x22, 0x33, 0x24, 0x36,
    0x36, 0x36, 0x36, 0x22, 0x2f, 0x2a, 0x23, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x50, 0x38, 0x3e, 0x51,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x29, 0x29, 0x29, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x2c, 0x3a, 0x44, 0x44, 0x52,
    0x20, 0x20, 0x20, 0x23, 0x32, 0x2f, 0x36, 0x36,
    0x30, 0x3b, 0x41, 0x24, 0x24, 0x36, 0x36, 0x36,
    0x23, 0x2f, 0x53, 0x54, 0x55, 0x30, 0x25, 0x21,
    0x36, 0x36, 0x36, 0x36, 0x2f, 0x32, 0x23, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x51, 0x3e, 0x37, 0x42,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x34, 0x44, 0x45, 0x3e, 0x45,
    0x20, 0x20, 0x20, 0x23, 0x32, 0x2f, 0x36, 0x23,
    0x56, 0x4d, 0x57, 0x3b, 0x22, 0x36, 0x36, 0x21,
    0x49, 0x51, 0x4c, 0x45, 0x40, 0x56, 0x23, 0x21,
    0x36, 0x36, 0x36, 0x36, 0x2f, 0x33, 0x28, 0x21,
    0x20, 0x20, 0x20, 0x20, 0x40, 0x44, 0x38, 0x51,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x29, 0x20, 0x29, 0x29, 0x29, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x2e, 0x44, 0x40, 0x44, 0x42,
    0x20, 0x20, 0x20, 0x23, 0x32, 0x2f, 0x36, 0x2b,
    0x45, 0x57, 0x44, 0x39, 0x35, 0x36, 0x36, 0x26,
    0x4c, 0x58, 0x59, 0x3d, 0x3f, 0x3e, 0x2e, 0x36,
    0x36, 0x36, 0x36, 0x36, 0x31, 0x35, 0x24, 0x21,
    0x20, 0x20, 0x20, 0x20, 0x57, 0x44, 0x3e, 0x48,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x5a, 0x44, 0x45, 0x3e, 0x44,
    0x20, 0x20, 0x20, 0x23, 0x32, 0x34, 0x36, 0x4b,
    0x5b, 0x25, 0x2f, 0x44, 0x3d, 0x22, 0x23, 0x32,
    0x3a, 0x42, 0x21, 0x31, 0x43, 0x46, 0x50, 0x36,
    0x36, 0x36, 0x36, 0x36, 0x31, 0x35, 0x24, 0x21,
    0x20, 0x20, 0x20, 0x20, 0x47, 0x3e, 0x38, 0x50,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x29, 0x20, 0x29, 0x29, 0x29, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x49, 0x40, 0x40, 0x44, 0x38,
    0x20, 0x20, 0x20, 0x23, 0x2a, 0x2f, 0x21, 0x3b,
    0x4b, 0x21, 0x31, 0x5c, 0x5d, 0x28, 0x30, 0x2b,
    0x3f, 0x4b, 0x36, 0x23, 0x32, 0x42, 0x4d, 0x36,
    0x36, 0x36, 0x36, 0x36, 0x2e, 0x5a, 0x24, 0x21,
    0x20, 0x20, 0x20, 0x20, 0x42, 0x44, 0x44, 0x52,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x29, 0x20, 0x29, 0x20, 0x29, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x2c, 0x4c, 0x40, 0x4c, 0x37,
    0x20, 0x20, 0x20, 0x23, 0x2a, 0x41, 0x23, 0x3c,
    0x5d, 0x36, 0x28, 0x3b, 0x5e, 0x5f, 0x5f, 0x60,
    0x54, 0x4b, 0x36, 0x36, 0x36, 0x57, 0x57, 0x21,
    0x36, 0x36, 0x36, 0x36, 0x2e, 0x5a, 0x24, 0x21,
    0x20, 0x20, 0x20, 0x20, 0x40, 0x44, 0x3a, 0x5c,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x29, 0x29, 0x29, 0x20, 0x29, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x2a, 0x44, 0x45, 0x4c, 0x3a,
    0x20, 0x20, 0x20, 0x22, 0x30, 0x43, 0x23, 0x35,
    0x4c, 0x25, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66,
    0x67, 0x68, 0x69, 0x36, 0x31, 0x39, 0x53, 0x36,
    0x36, 0x36, 0x36, 0x36, 0x31, 0x2c, 0x25, 0x21,
    0x20, 0x20, 0x20, 0x20, 0x52, 0x45, 0x44, 0x54,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x2a, 0x40, 0x4d, 0x4c, 0x38,
    0x20, 0x20, 0x20, 0x22, 0x30, 0x2f, 0x23, 0x22,
    0x57, 0x6a, 0x6b, 0x65, 0x6c, 0x6d, 0x6e, 0x6f,
    0x70, 0x71, 0x6e, 0x66, 0x72, 0x73, 0x2a, 0x36,
    0x36, 0x36, 0x36, 0x36, 0x33, 0x2e, 0x26, 0x21,
    0x20, 0x20, 0x20, 0x20, 0x51, 0x3a, 0x44, 0x47,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x2c, 0x45, 0x4c, 0x4c, 0x38,
    0x20, 0x20, 0x20, 0x22, 0x27, 0x2f, 0x23, 0x36,
    0x74, 0x6b, 0x75, 0x6c, 0x64, 0x6e, 0x71, 0x76,
    0x77, 0x78, 0x79, 0x71, 0x71, 0x7a, 0x74, 0x36,
    0x36, 0x36, 0x36, 0x36, 0x33, 0x34, 0x27, 0x22,
    0x20, 0x20, 0x20, 0x20, 0x54, 0x44, 0x44, 0x54,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x5a, 0x48, 0x48, 0x4f, 0x37,
    0x20, 0x20, 0x20, 0x22, 0x27, 0x34, 0x26, 0x7b,
    0x7c, 0x7d, 0x7e, 0x6c, 0x6d, 0x7f, 0x71, 0x80,
    0x78, 0x79, 0x79, 0x79, 0x7a, 0x67, 0x66, 0x21,
    0x36, 0x36, 0x36, 0x36, 0x25, 0x41, 0x2a, 0x23,
    0x20, 0x20, 0x20, 0x20, 0x81, 0x44, 0x40, 0x5b,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x2c, 0x44, 0x45, 0x4f, 0x38,
    0x20, 0x20, 0x20, 0x22, 0x26, 0x2d, 0x33, 0x82,
    0x6b, 0x83, 0x84, 0x64, 0x6e, 0x71, 0x76, 0x85,
    0x79, 0x79, 0x71, 0x86, 0x87, 0x83, 0x88, 0x36,
    0x36, 0x36, 0x36, 0x36, 0x21, 0x43, 0x2b, 0x28,
    0x21, 0x20, 0x20, 0x20, 0x52, 0x44, 0x44, 0x50,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x5a, 0x40, 0x4d, 0x4f, 0x38,
    0x20, 0x20, 0x20, 0x22, 0x26, 0x2d, 0x32, 0x24,
    0x89, 0x8a, 0x6c, 0x8b, 0x7f, 0x71, 0x79, 0x79,
    0x71, 0x8c, 0x8d, 0x8e, 0x83, 0x8e, 0x8f, 0x36,
    0x21, 0x2b, 0x23, 0x36, 0x36, 0x5a, 0x2e, 0x26,
    0x22, 0x20, 0x20, 0x20, 0x42, 0x40, 0x38, 0x50,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x2c, 0x4c, 0x4f, 0x4f, 0x38,
    0x20, 0x20, 0x20, 0x22, 0x27, 0x2d, 0x33, 0x21,
    0x90, 0x91, 0x92, 0x7a, 0x6f, 0x6e, 0x67, 0x92,
    0x93, 0x6b, 0x8e, 0x94, 0x95, 0x96, 0x49, 0x36,
    0x36, 0x2d, 0x3b, 0x35, 0x36, 0x24, 0x43, 0x32,
    0x28, 0x21, 0x20, 0x20, 0x57, 0x40, 0x44, 0x54,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x34, 0x4d, 0x42, 0x51, 0x38,
    0x20, 0x20, 0x20, 0x22, 0x30, 0x2f, 0x33, 0x21,
    0x5d, 0x97, 0x98, 0x93, 0x86, 0x66, 0x99, 0x87,
    0x7d, 0x7d, 0x99, 0x6a, 0x57, 0x4d, 0x59, 0x23,
    0x36, 0x24, 0x3b, 0x3b, 0x24, 0x36, 0x2e, 0x31,
    0x26, 0x22, 0x20, 0x20, 0x52, 0x44, 0x44, 0x9a,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x5a, 0x57, 0x57, 0x57, 0x37,
    0x20, 0x20, 0x21, 0x28, 0x33, 0x3c, 0x25, 0x22,
    0x53, 0x42, 0x97, 0x98, 0x99, 0x87, 0x99, 0x6b,
    0x7c, 0x9b, 0x9c, 0x51, 0x4f, 0x3f, 0x40, 0x2c,
    0x36, 0x36, 0x33, 0x5a, 0x21, 0x36, 0x22, 0x43,
    0x33, 0x28, 0x21, 0x20, 0x42, 0x44, 0x37, 0x4f,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x2a, 0x51, 0x42, 0x51, 0x37,
    0x20, 0x20, 0x22, 0x27, 0x2e, 0x2e, 0x36, 0x21,
    0x4e, 0x4d, 0x42, 0x9d, 0x9e, 0x98, 0x98, 0x9f,
    0x97, 0x51, 0x42, 0x4c, 0x39, 0x58, 0x58, 0x47,
    0x21, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x5a,
    0x2e, 0x27, 0x23, 0x20, 0x59, 0x48, 0x38, 0x50,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x2a, 0x42, 0x51, 0x42, 0x3e,
    0x20, 0x22, 0x24, 0x2b, 0x41, 0x28, 0x36, 0x32,
    0x3e, 0x3f, 0x42, 0x42, 0x42, 0x51, 0x51, 0x42,
    0x42, 0x57, 0x40, 0x38, 0x58, 0x58, 0x58, 0x58,
    0x34, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x23,
    0x2f, 0x2b, 0x24, 0x21, 0x57, 0x4f, 0x3e, 0x53,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x33, 0x47, 0x51, 0x52, 0x38,
    0x21, 0x28, 0x32, 0x43, 0x32, 0x28, 0x21, 0x47,
    0x58, 0x39, 0x48, 0x42, 0x42, 0x42, 0x42, 0x42,
    0x48, 0x3a, 0x37, 0x58, 0x58, 0x58, 0x58, 0x58,
    0x4f, 0x23, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36,
    0x2a, 0x2f, 0x2a, 0x28, 0x42, 0x4f, 0x44, 0x52,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x5a, 0x57, 0x47, 0x51, 0x37,
    0x23, 0x30, 0x2e, 0x2c, 0x36, 0x21, 0x43, 0x37,
    0x58, 0x58, 0x46, 0x4d, 0x42, 0x42, 0x57, 0x3f,
    0x39, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58,
    0x58, 0x34, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36,
    0x36, 0x2d, 0x31, 0x27, 0x4f, 0x47, 0x38, 0x50,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x25, 0x57, 0x47, 0x52, 0x38,
    0x27, 0x2c, 0x2d, 0x21, 0x36, 0x28, 0x45, 0x58,
    0x58, 0x58, 0x58, 0x39, 0x44, 0x3a, 0x39, 0x58,
    0x58, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58,
    0x58, 0x52, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36,
    0x36, 0x28, 0x43, 0x5a, 0x45, 0x4d, 0x37, 0x9a,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x2a, 0x47, 0x52, 0x59, 0x37,
    0x35, 0x43, 0x28, 0x36, 0x36, 0x4a, 0x58, 0x58,
    0x58, 0x58, 0x58, 0x58, 0x37, 0x58, 0x58, 0x58,
    0x58, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58,
    0x58, 0x3a, 0x28, 0x36, 0x36, 0x36, 0x36, 0x36,
    0x36, 0x36, 0x28, 0x41, 0x48, 0x4d, 0x38, 0x54,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x2a, 0x81, 0x5b, 0x51, 0x38,
    0x43, 0x25, 0x36, 0x36, 0x23, 0x57, 0x37, 0x58,
    0x58, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58,
    0x58, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58,
    0x37, 0x38, 0x2b, 0x36, 0x36, 0x36, 0x36, 0x36,
    0x36, 0x36, 0x36, 0x30, 0x51, 0x40, 0x3a, 0x56,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x33, 0x51, 0x47, 0x81, 0x3e,
    0x27, 0x36, 0x36, 0x36, 0x2a, 0x57, 0x39, 0x58,
    0x58, 0x58, 0x58, 0x37, 0x38, 0x38, 0x37, 0x58,
    0x58, 0x58, 0x58, 0x58, 0x58, 0x37, 0x39, 0x46,
    0x44, 0x3a, 0x3c, 0x21, 0x36, 0x36, 0x36, 0x36,
    0x36, 0x36, 0x36, 0x36, 0x48, 0x59, 0x37, 0x5d,
    0x21, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x27, 0x52, 0x4e, 0x5b, 0x44,
    0x36, 0x36, 0x36, 0x21, 0x31, 0x5b, 0x48, 0x3e,
    0x39, 0x37, 0x37, 0x46, 0x44, 0x3a, 0x46, 0x37,
    0x37, 0x37, 0x39, 0x3a, 0x40, 0x48, 0x4f, 0x4f,
    0x4d, 0x4f, 0x47, 0x28, 0x36, 0x36, 0x36, 0x36,
    0x36, 0x36, 0x36, 0x36, 0x4f, 0x81, 0x40, 0x5d,
    0x22, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x33, 0x52, 0x50, 0x56, 0x38,
    0x36, 0x36, 0x36, 0x22, 0x41, 0x47, 0x45, 0x38,
    0x37, 0x58, 0x58, 0x37, 0x3e, 0x58, 0x58, 0x58,
    0x58, 0x58, 0x58, 0x39, 0x46, 0x44, 0x4c, 0x4f,
    0x57, 0x57, 0x4c, 0x50, 0x21, 0x23, 0x33, 0x23,
    0x36, 0x36, 0x36, 0x36, 0x4d, 0x51, 0x39, 0x3b,
    0x28, 0x21, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x33, 0x57, 0x55, 0x55, 0x37,
    0x37, 0x37, 0x38, 0x38, 0x38, 0x37, 0x37, 0x37,
    0x37, 0x37, 0x38, 0x37, 0x37, 0x37, 0x38, 0x37,
    0x37, 0x37, 0x37, 0x39, 0x3e, 0x37, 0x38, 0x38,
    0x38, 0x37, 0x38, 0x38, 0x38, 0x37, 0x38, 0x38,
    0x37, 0x38, 0x38, 0x37, 0x47, 0x42, 0x48, 0x9a,
    0x25, 0x22, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x33, 0x5b, 0x81, 0x5d, 0x37,
    0x38, 0x37, 0x37, 0x38, 0x37, 0x38, 0x38, 0x37,
    0x38, 0x37, 0x37, 0x37, 0x37, 0x37, 0x38, 0x37,
    0x38, 0x37, 0x38, 0x37, 0x37, 0x38, 0x37, 0x37,
    0x38, 0x37, 0x37, 0x37, 0x38, 0x38, 0x37, 0x3e,
    0x37, 0x38, 0x38, 0x37, 0x57, 0x57, 0x48, 0x5d,
    0x2a, 0x23, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x33, 0x52, 0x59, 0x50, 0x5b,
    0x54, 0x5b, 0x5b, 0x54, 0x81, 0x5b, 0x55, 0x55,
    0x52, 0x54, 0x81, 0x81, 0x81, 0x50, 0x52, 0x54,
    0x5b, 0x59, 0x52, 0x52, 0x5b, 0x52, 0x5b, 0x81,
    0x5b, 0x47, 0x51, 0x52, 0x57, 0x57, 0x57, 0x57,
    0x51, 0x57, 0x52, 0x57, 0x48, 0x57, 0x4c, 0x3b,
    0x35, 0x24, 0x21, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x21, 0x33, 0x54, 0x54, 0x5b, 0x50,
    0x54, 0x50, 0x54, 0x81, 0x50, 0x59, 0x54, 0x50,
    0x5b, 0x81, 0x81, 0x59, 0x81, 0x59, 0x59, 0x59,
    0x59, 0x47, 0x81, 0x51, 0x47, 0x51, 0x59, 0x81,
    0x81, 0x51, 0x47, 0x50, 0x59, 0x59, 0x59, 0x47,
    0x47, 0x47, 0x52, 0x57, 0x52, 0x47, 0x59, 0x26,
    0x2d, 0x26, 0x22, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x22, 0x27, 0x55, 0x50, 0x55, 0x50,
    0x55, 0x81, 0x54, 0x52, 0x52, 0x81, 0x5b, 0x50,
    0x5b, 0x52, 0x52, 0x51, 0x57, 0x52, 0x52, 0x52,
    0x54, 0x51, 0x81, 0x52, 0x59, 0x52, 0x5b, 0x5b,
    0x59, 0x5b, 0x51, 0x52, 0x52, 0x4f, 0x5b, 0x51,
    0x52, 0x47, 0x59, 0x42, 0x47, 0x81, 0x5c, 0x21,
    0x2f, 0x32, 0x23, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x21, 0x23, 0x33, 0x81, 0x54, 0x5c, 0x54,
    0x50, 0x5b, 0x50, 0x50, 0x81, 0x5b, 0x5c, 0x5b,
    0x50, 0x59, 0x81, 0x81, 0x81, 0x81, 0x47, 0x50,
    0x50, 0x59, 0x5b, 0x50, 0x52, 0x81, 0x50, 0x59,
    0x5b, 0x81, 0x59, 0x81, 0x59, 0x47, 0x59, 0x47,
    0x59, 0x52, 0x51, 0x48, 0x51, 0x52, 0x5d, 0x36,
    0x2e, 0x35, 0x24, 0x21, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x22, 0x25, 0x2a, 0x50, 0x4e, 0x5c, 0x54,
    0x5c, 0x5b, 0x5b, 0x5b, 0x59, 0x5b, 0x50, 0x54,
    0x5b, 0x54, 0x5b, 0x5b, 0x54, 0x54, 0x5b, 0x5b,
    0x5b, 0x81, 0x55, 0x81, 0x55, 0x54, 0x5b, 0x5c,
    0x5b, 0x4e, 0x51, 0x5b, 0x5b, 0x57, 0x51, 0x4f,
    0x4d, 0x47, 0x4f, 0x4c, 0x51, 0x52, 0x4b, 0x36,
    0x2a, 0x2e, 0x26, 0x22, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x21, 0x23, 0x2a, 0x2a, 0x50, 0x9a, 0x54, 0x5c,
    0x55, 0x50, 0x81, 0x59, 0x54, 0x50, 0x54, 0x50,
    0x50, 0x50, 0x81, 0x81, 0x50, 0x50, 0x50, 0x81,
    0x81, 0x5b, 0x47, 0x51, 0x81, 0x59, 0x81, 0x55,
    0x59, 0x59, 0x81, 0x42, 0x27, 0x36, 0x28, 0x36,
    0x27, 0x36, 0x28, 0x2d, 0x47, 0x52, 0x2d, 0x36,
    0x22, 0x2f, 0x30, 0x22, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x22, 0x25, 0x2c, 0x26, 0x53, 0x4e, 0x55, 0x5c,
    0x55, 0x55, 0x55, 0x81, 0x54, 0x50, 0x54, 0x55,
    0x5b, 0x55, 0x52, 0x54, 0x54, 0x5b, 0x54, 0x55,
    0x36, 0x36, 0x27, 0x2a, 0x2a, 0x27, 0xa0, 0x27,
    0x2a, 0x2a, 0x2c, 0x27, 0x5d, 0x22, 0x22, 0x28,
    0x28, 0x22, 0x25, 0x59, 0x51, 0x53, 0x27, 0x36,
    0x21, 0x2f, 0x32, 0x23, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x21,
    0x28, 0x32, 0x2f, 0x21, 0x4a, 0x54, 0x5c, 0x4e,
    0x5c, 0x81, 0x5c, 0x54, 0x5c, 0x54, 0x5c, 0x50,
    0x81, 0x50, 0x50, 0x81, 0x81, 0x5c, 0x50, 0x81,
    0x5d, 0x28, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36,
    0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0xa0, 0x25,
    0x28, 0x21, 0x28, 0x81, 0x59, 0x4a, 0x28, 0x36,
    0x36, 0x34, 0x2b, 0x28, 0x21, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x22,
    0x25, 0x2c, 0x5a, 0x36, 0x32, 0x9a, 0x81, 0x4e,
    0x55, 0x5b, 0x50, 0x54, 0x5c, 0x54, 0x55, 0x55,
    0x54, 0x4e, 0x54, 0x55, 0x5b, 0x4e, 0x55, 0x5b,
    0x3b, 0x4e, 0x4a, 0x3b, 0x4a, 0x4e, 0x3b, 0x5d,
    0x56, 0x3b, 0x56, 0x5c, 0x50, 0x3a, 0x3e, 0x40,
    0x4f, 0x57, 0x81, 0x4e, 0x4e, 0x27, 0x36, 0x36,
    0x36, 0x2c, 0x35, 0x24, 0x21, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x22,
    0x30, 0x2d, 0x21, 0x36, 0x23, 0x3d, 0x53, 0x43,
    0x4a, 0x5d, 0x55, 0x5c, 0x4e, 0x5c, 0x50, 0x5c,
    0x81, 0x50, 0x50, 0x81, 0x50, 0x50, 0x50, 0x50,
    0x4e, 0x5b, 0x54, 0x5b, 0x51, 0x59, 0x5b, 0x5b,
    0x54, 0x5b, 0x5b, 0x52, 0x51, 0x42, 0x5b, 0x5c,
    0x5c, 0x53, 0x5b, 0x3b, 0x28, 0x36, 0x36, 0x36,
    0x36, 0x2c, 0x5a, 0x24, 0x21, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x21, 0x28,
    0x33, 0x2e, 0x36, 0x36, 0x23, 0x41, 0x56, 0x2e,
    0x33, 0x50, 0x55, 0x81, 0x54, 0x5b, 0x54, 0x52,
    0x5b, 0x55, 0x54, 0x55, 0x55, 0x55, 0x5b, 0x9a,
    0x5c, 0x81, 0x81, 0x81, 0x52, 0x59, 0x50, 0x59,
    0x59, 0x59, 0x59, 0x50, 0x81, 0x81, 0x5b, 0x5b,
    0x5b, 0x54, 0x34, 0x22, 0x36, 0x36, 0x36, 0x36,
    0x36, 0x2c, 0x5a, 0x24, 0x21, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x21, 0x28,
    0x2b, 0x5a, 0x36, 0x36, 0x36, 0x27, 0x3d, 0x28,
    0xa0, 0x5d, 0x5c, 0x55, 0x50, 0x50, 0x5c, 0x81,
    0x81, 0x50, 0x50, 0x47, 0x50, 0x5c, 0x5c, 0x52,
    0x54, 0x5b, 0x5b, 0x5b, 0x59, 0x52, 0x5b, 0x52,
    0x5b, 0x52, 0x52, 0x54, 0x59, 0x5b, 0x81, 0x81,
    0x9a, 0x33, 0x26, 0x36, 0x36, 0x36, 0x36, 0x36,
    0x36, 0x2c, 0x35, 0x24, 0x21, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x21, 0x24,
    0x35, 0x5a, 0x36, 0x36, 0x36, 0x36, 0x30, 0x4e,
    0x52, 0x54, 0x56, 0x55, 0x55, 0x55, 0x55, 0x5b,
    0x55, 0x55, 0x54, 0x5b, 0x54, 0x55, 0x50, 0x59,
    0x5c, 0x81, 0x59, 0x52, 0x59, 0x59, 0x81, 0x59,
    0x81, 0x81, 0x81, 0x81, 0x5b, 0x5b, 0x81, 0x53,
    0x2a, 0x27, 0xa1, 0x24, 0x25, 0x28, 0x21, 0x36,
    0x36, 0x34, 0x2b, 0x28, 0x21, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x21, 0x25,
    0x5a, 0x4b, 0xa2, 0x8d, 0x8a, 0x5f, 0x21, 0x2d,
    0x55, 0x5c, 0x9a, 0x5c, 0x5c, 0x5c, 0x50, 0x9a,
    0x5c, 0x9a, 0x50, 0x5c, 0x5c, 0x5c, 0x54, 0x5b,
    0x55, 0x5b, 0x54, 0x81, 0x5b, 0x5b, 0x5b, 0x54,
    0x54, 0x5b, 0x5b, 0x5b, 0x5b, 0x54, 0x54, 0x30,
    0x23, 0x36, 0x36, 0x36, 0x21, 0x28, 0x2c, 0x30,
    0x21, 0x41, 0x33, 0x28, 0x21, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x21, 0x22, 0x22, 0x28, 0x30,
    0x2d, 0xa3, 0x83, 0xa4, 0xa5, 0xa5, 0x88, 0x22,
    0x3b, 0x47, 0x53, 0x55, 0x55, 0x53, 0x54, 0x5b,
    0x52, 0x53, 0x54, 0x54, 0x54, 0x50, 0x5c, 0x59,
    0x56, 0x59, 0x5b, 0x50, 0x50, 0x59, 0x9a, 0x59,
    0x5c, 0x81, 0x50, 0x59, 0x9a, 0x52, 0x68, 0x69,
    0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x30, 0x32,
    0x25, 0x4b, 0x2b, 0x28, 0x21, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x21, 0x23, 0x24, 0x26, 0x30, 0x33, 0x31,
    0x4b, 0x9b, 0x63, 0xa4, 0xa5, 0xa5, 0xa5, 0x62,
    0x21, 0x2e, 0x44, 0x58, 0x58, 0x58, 0x58, 0x58,
    0x58, 0x58, 0x3a, 0x37, 0x58, 0x58, 0x58, 0x58,
    0x58, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58,
    0x58, 0x58, 0x58, 0xa6, 0xa7, 0x71, 0x6e, 0xa8,
    0x36, 0x36, 0x36, 0x36, 0x36, 0x21, 0x26, 0x25,
    0x8c, 0xa9, 0x2c, 0x25, 0x21, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x21, 0x28, 0x30, 0x35, 0x2d, 0x2f, 0x3c, 0x3d,
    0x68, 0x8e, 0xaa, 0xab, 0xa5, 0xa5, 0xa5, 0x8b,
    0x8f, 0x36, 0x32, 0x4d, 0x58, 0x58, 0x58, 0x58,
    0x58, 0x58, 0x3e, 0x38, 0x58, 0x58, 0x58, 0x58,
    0x58, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58,
    0x58, 0x58, 0x58, 0xac, 0xa4, 0xa7, 0xad, 0xa0,
    0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x21, 0x5f,
    0x7f, 0x6e, 0x34, 0x27, 0x22, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x23, 0x30, 0x31, 0xae, 0x9b, 0x87, 0x99, 0x99,
    0x94, 0x63, 0xa4, 0xa5, 0xa5, 0xa5, 0xa5, 0xa5,
    0x65, 0xaf, 0x36, 0x24, 0x50, 0x37, 0x58, 0x58,
    0x58, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58,
    0x58, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58,
    0x58, 0x37, 0x38, 0xac, 0x6c, 0x64, 0x94, 0xaf,
    0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x7b, 0x65,
    0x8b, 0x64, 0xb0, 0x2a, 0x23, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x21,
    0x24, 0x2b, 0xae, 0x94, 0x63, 0x7e, 0x63, 0x63,
    0x84, 0xa4, 0xa5, 0xa5, 0xa5, 0xa5, 0xa5, 0xa5,
    0xa7, 0x66, 0x22, 0x36, 0x21, 0x3b, 0x38, 0x58,
    0x58, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58,
    0x58, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58,
    0x58, 0x3a, 0x4d, 0xb1, 0x84, 0x84, 0x8e, 0x89,
    0xa1, 0x36, 0x36, 0x36, 0x21, 0xb2, 0x87, 0x84,
    0x6c, 0x6c, 0xb3, 0x35, 0x24, 0x21, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x22,
    0x26, 0x31, 0xb4, 0x63, 0x6c, 0xa4, 0xa4, 0xab,
    0xa5, 0xa5, 0xa5, 0xa5, 0xa5, 0xa5, 0xa5, 0xa5,
    0xa5, 0x6e, 0xb5, 0x36, 0x36, 0x36, 0x2c, 0x3f,
    0x58, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58,
    0x58, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58,
    0x58, 0x48, 0x4d, 0xb6, 0x7e, 0x7e, 0x83, 0x6b,
    0xb7, 0xb8, 0x8f, 0xb8, 0xb9, 0x99, 0x63, 0x6c,
    0xa4, 0xa4, 0xba, 0x2d, 0x27, 0x23, 0x21, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x21,
    0x26, 0x2d, 0x9b, 0x63, 0x6c, 0xa5, 0xa5, 0xa5,
    0xa5, 0xa5, 0xa5, 0xa5, 0xa5, 0xa5, 0xa5, 0xa5,
    0xa5, 0xa7, 0x8c, 0xa0, 0x36, 0x36, 0x36, 0x30,
    0x45, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58,
    0x58, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58,
    0x37, 0x48, 0x4d, 0xbb, 0x63, 0x84, 0xbc, 0x8e,
    0x87, 0x99, 0x6b, 0x99, 0x8e, 0x63, 0xa4, 0xa5,
    0xa5, 0xab, 0x65, 0xb3, 0x5a, 0x26, 0x23, 0x21,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x22,
    0x26, 0x2d, 0xbd, 0xbc, 0x6c, 0xa5, 0xa5, 0xa5,
    0xa5, 0xa5, 0xa5, 0xa5, 0xa5, 0xa5, 0xa5, 0xa5,
    0xa5, 0xa5, 0xa7, 0x91, 0x36, 0x36, 0x36, 0x36,
    0x2d, 0x37, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58,
    0x58, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58,
    0x37, 0x40, 0x4d, 0xbe, 0x75, 0x84, 0xaa, 0xbc,
    0x83, 0x94, 0x94, 0x83, 0x63, 0x6c, 0xa5, 0xa5,
    0xa5, 0xa5, 0xa4, 0xbf, 0x3c, 0x35, 0x26, 0x23,
    0x21, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x22,
    0x26, 0x2e, 0xbd, 0x83, 0x84, 0xa5, 0xa5, 0xa5,
    0xa5, 0xa5, 0xa5, 0xa5, 0xa5, 0xa5, 0xa5, 0xa5,
    0xa5, 0xa5, 0xa7, 0x7a, 0x7b, 0x36, 0x36, 0x36,
    0x24, 0x46, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58,
    0x58, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58,
    0x58, 0x44, 0x51, 0xb4, 0x83, 0x84, 0x6c, 0x84,
    0x7e, 0x63, 0x63, 0x7e, 0x84, 0xa4, 0xa5, 0xa5,
    0xa5, 0xa5, 0xab, 0x6c, 0xbf, 0x4b, 0x2c, 0x27,
    0x23, 0x21, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x21,
    0x25, 0x31, 0xc0, 0x94, 0x84, 0xa5, 0xa5, 0xa5,
    0xa5, 0xa5, 0xa5, 0xa5, 0xa5, 0xa5, 0xa5, 0xa5,
    0xa5, 0xa5, 0xa5, 0xa7, 0x92, 0xa1, 0x36, 0x36,
    0x32, 0x39, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58,
    0x58, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58,
    0x58, 0x3f, 0x2f, 0x98, 0x83, 0x84, 0xa4, 0xab,
    0xa4, 0x6c, 0x6c, 0xa4, 0xa4, 0xab, 0xa5, 0xa5,
    0xa5, 0xa5, 0xa5, 0xa5, 0xa4, 0x65, 0xc1, 0x2c,
    0x26, 0x22, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x21,
    0x25, 0x31, 0xc0, 0x8e, 0x84, 0xa5, 0xa5, 0xa5,
    0xa5, 0xa5, 0xa5, 0xa5, 0xa5, 0xa5, 0xa5, 0xa5,
    0xa5, 0xa5, 0xa5, 0xa5, 0x6e, 0x5f, 0x27, 0x4b,
    0x3f, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58,
    0x58, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58,
    0x38, 0x34, 0xa1, 0xb7, 0x83, 0x84, 0xa4, 0xa5,
    0xa5, 0xa5, 0xa5, 0xa5, 0xa5, 0xa5, 0xa5, 0xa5,
    0xa5, 0xa5, 0xa5, 0xa5, 0xa5, 0xa5, 0xa4, 0xc0,
    0x32, 0x28, 0x21, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x22,
    0x26, 0x2d, 0xc0, 0x8e, 0x84, 0xab, 0xa5, 0xa5,
    0xa5, 0xa5, 0xa5, 0xa5, 0xa5, 0xa5, 0xa5, 0xa5,
    0xa5, 0xa5, 0xa5, 0xa5, 0xa7, 0x67, 0x9c, 0x58,
    0x58, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58,
    0x58, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58, 0x45,
    0x35, 0x36, 0xa0, 0xb9, 0x83, 0x84, 0xab, 0xa5,
    0xa5, 0xa5, 0xa5, 0xa5, 0xa5, 0xa5, 0xa5, 0xa5,
    0xa5, 0xa5, 0xa5, 0xa5, 0xa5, 0xab, 0xa4, 0xbe,
    0x2b, 0x24, 0x21, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x23,
    0x30, 0x2f, 0xb4, 0x94, 0x84, 0xab, 0xa5, 0xa5,
    0xa5, 0xa5, 0xa5, 0xa5, 0xa5, 0xa5, 0xa5, 0xa5,
    0xa5, 0xa5, 0xa5, 0xa5, 0xa5, 0x6e, 0x92, 0x40,
    0x58, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58,
    0x58, 0x58, 0x58, 0x58, 0x58, 0x37, 0x5b, 0x25,
    0x36, 0x36, 0x69, 0xb7, 0x75, 0x6c, 0xab, 0xa5,
    0xa5, 0xa5, 0xa5, 0xa5, 0xa5, 0xa5, 0xa5, 0xa5,
    0xa5, 0xa5, 0xa5, 0xa5, 0xab, 0x84, 0xbc, 0xc1,
    0x32, 0x28, 0x21, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x21, 0x28,
    0x33, 0xc2, 0x6b, 0xbc, 0xa4, 0xa5, 0xa5, 0xa5,
    0xa5, 0xa5, 0xa5, 0xa5, 0xa5, 0xa5, 0xa5, 0xa5,
    0xa5, 0xa5, 0xa5, 0xa5, 0xa4, 0x7a, 0x8a, 0xc3,
    0x44, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58,
    0x58, 0x58, 0x58, 0x58, 0x4d, 0x2c, 0x36, 0x36,
    0x36, 0x36, 0xc4, 0x98, 0x75, 0x6c, 0xab, 0xa5,
    0xa5, 0xa5, 0xa5, 0xa5, 0xa5, 0xa5, 0xa5, 0xa5,
    0xa5, 0xa5, 0xa5, 0xa4, 0xaa, 0x94, 0xae, 0x2c,
    0x26, 0x22, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x21, 0x24,
    0x35, 0x9e, 0x7d, 0xaa, 0xa4, 0xab, 0xa5, 0xa5,
    0xa5, 0xa5, 0xa5, 0xa5, 0xa5, 0xa5, 0xa5, 0xa5,
    0xa5, 0xa5, 0xa5, 0xa5, 0xab, 0x84, 0x8a, 0xb7,
    0x7b, 0x53, 0x45, 0x37, 0x58, 0x58, 0x58, 0x37,
    0x38, 0x4c, 0x4e, 0x2c, 0x21, 0x36, 0x36, 0x36,
    0x36, 0x36, 0x7b, 0xb7, 0x83, 0x84, 0xa5, 0xa5,
    0xa5, 0xa5, 0xa5, 0xa5, 0xa5, 0xa5, 0xa5, 0xa5,
    0xa5, 0x6c, 0x7e, 0x83, 0x9b, 0xb3, 0x31, 0x30,
    0x28, 0x21, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x21, 0x24,
    0x5a, 0x9f, 0x7d, 0xbc, 0x84, 0x6c, 0xa4, 0xa4,
    0xab, 0xa5, 0xa5, 0xa5, 0xa5, 0xa5, 0xa5, 0xa5,
    0xa5, 0xa5, 0xa5, 0xa5, 0xa5, 0x84, 0x83, 0xc5,
    0xc6, 0x36, 0x21, 0x26, 0x2b, 0x5a, 0x33, 0x30,
    0x23, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36,
    0x36, 0x21, 0xc6, 0xb9, 0x94, 0x84, 0xa5, 0xa5,
    0xa5, 0xa5, 0xa5, 0xa5, 0xa5, 0xa4, 0x6c, 0x6c,
    0x7e, 0x8e, 0xbd, 0xb3, 0x34, 0x2b, 0x27, 0x28,
    0x21, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x21, 0x28,
    0x33, 0xc7, 0x6b, 0x87, 0x83, 0x75, 0xbc, 0x63,
    0x7e, 0x84, 0x6c, 0x6c, 0xa4, 0xab, 0xa5, 0xa5,
    0xa5, 0xa5, 0xa5, 0xa5, 0xab, 0x7e, 0x8e, 0xb7,
    0x82, 0x22, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36,
    0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36,
    0x36, 0x21, 0xc8, 0xb9, 0x7d, 0x7e, 0xa4, 0xa5,
    0xa5, 0xa5, 0xab, 0xa4, 0x6c, 0x7e, 0xbc, 0x94,
    0xb4, 0xb3, 0x2f, 0x35, 0x30, 0x24, 0x22, 0x21,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x23,
    0x27, 0x31, 0xc9, 0xc7, 0xb9, 0x7c, 0x6b, 0x99,
    0x87, 0x7d, 0x94, 0x75, 0xbc, 0x7e, 0x6c, 0xa4,
    0xab, 0xab, 0xab, 0xab, 0x6c, 0x83, 0x8d, 0xca,
    0x82, 0xa1, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36,
    0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36,
    0x36, 0x21, 0xc6, 0xca, 0x6b, 0x75, 0x84, 0x6c,
    0xab, 0xa4, 0x6c, 0x84, 0xbc, 0x7d, 0x6b, 0x9e,
    0x41, 0x5a, 0x2a, 0x24, 0x23, 0x21, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x21,
    0x28, 0x27, 0x35, 0x2d, 0x49, 0xb3, 0xc3, 0x98,
    0xb7, 0xb9, 0xc5, 0x7c, 0x8d, 0x99, 0x8e, 0x75,
    0x63, 0x84, 0x84, 0xaa, 0x75, 0x99, 0xb7, 0xcb,
    0xc8, 0x22, 0x36, 0x36, 0x28, 0x30, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x25, 0x36,
    0x36, 0x21, 0xb2, 0x89, 0xc5, 0x87, 0x75, 0x7e,
    0xaa, 0x7e, 0x75, 0x8e, 0x6b, 0xb7, 0xb3, 0x34,
    0x33, 0x26, 0x23, 0x21, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x21, 0x23, 0x24, 0x27, 0x2a, 0x35, 0x2e, 0x2f,
    0x49, 0xcc, 0xcd, 0x74, 0x89, 0xca, 0xb7, 0x7c,
    0x8d, 0x99, 0x7d, 0x87, 0x7c, 0x98, 0xcb, 0x82,
    0xc4, 0x2b, 0x4a, 0x49, 0x2f, 0x34, 0x2d, 0x2d,
    0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x34, 0x2f, 0x41,
    0x4b, 0x3c, 0xce, 0xcf, 0x98, 0x7c, 0x6b, 0x87,
    0x7d, 0x87, 0x6b, 0xc5, 0x91, 0xc2, 0x31, 0x2a,
    0x24, 0x22, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x21, 0x22, 0x23, 0x24, 0x26, 0x30,
    0x33, 0x5a, 0x2e, 0x43, 0x49, 0xb0, 0x74, 0xcf,
    0x89, 0xca, 0xca, 0xca, 0xd0, 0xcf, 0xb5, 0xd1,
    0x49, 0x34, 0x35, 0x32, 0x30, 0x27, 0x27, 0x27,
    0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x30, 0x2a,
    0x2b, 0x34, 0xd2, 0xc8, 0xd3, 0x98, 0xb9, 0xc5,
    0xc5, 0xb9, 0xca, 0x74, 0x49, 0x5a, 0x27, 0x28,
    0x21, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x21, 0x21, 0x22,
    0x28, 0x24, 0x26, 0x2a, 0x33, 0x2c, 0x2f, 0x49,
    0xd4, 0xb5, 0x82, 0x82, 0x82, 0xc8, 0xd5, 0x43,
    0x5a, 0x30, 0x24, 0x23, 0x22, 0x22, 0x22, 0x22,
    0x22, 0x22, 0x21, 0x22, 0x22, 0x22, 0x22, 0x23,
    0x24, 0x2a, 0x31, 0xd6, 0xc6, 0x82, 0xcf, 0x89,
    0xd3, 0xb8, 0xd7, 0x2f, 0x35, 0x26, 0x23, 0x21,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x21, 0x22, 0x23, 0x28, 0x25, 0x30, 0x2b,
    0x31, 0x2f, 0xd2, 0xd6, 0xd6, 0x2f, 0x2e, 0x33,
    0x26, 0x23, 0x21, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x21, 0x28, 0x27, 0x35, 0x34, 0xd6, 0xd6, 0xd6,
    0xd8, 0xd2, 0x2e, 0x33, 0x25, 0x23, 0x21, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x21, 0x21, 0x23, 0x28,
    0x26, 0x30, 0x32, 0x2b, 0x33, 0x2a, 0x26, 0x28,
    0x22, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x21, 0x23, 0x25, 0x30, 0x33, 0x35, 0x35,
    0x2b, 0x2a, 0x26, 0x28, 0x22, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x21,
    0x21, 0x22, 0x23, 0x28, 0x28, 0x23, 0x22, 0x21,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x21, 0x23, 0x28, 0x24, 0x24,
    0x28, 0x23, 0x22, 0x21, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
};

#endif /* !INCLUDE_LINUX_LOGO_DATA */

#endif /* CONFIG_MAC */

#include <linux/linux_logo.h>

