/*
 * include/asm-armnommu/arch-netarm/hardware.h
 *
 * Copyright (C) 2000 NETsilicon, Inc.
 * Copyright (C) 2000 WireSpeed Communications Corporation
 *
 * This software is copyrighted by WireSpeed. LICENSEE agrees that
 * it will not delete this copyright notice, trademarks or protective
 * notices from any copy made by LICENSEE.
 *
 * This software is provided "AS-IS" and any express or implied 
 * warranties or conditions, including but not limited to any
 * implied warranties of merchantability and fitness for a particular
 * purpose regarding this software. In no event shall WireSpeed
 * be liable for any indirect, consequential, or incidental damages,
 * loss of profits or revenue, loss of use or data, or interruption
 * of business, whether the alleged damages are labeled in contract,
 * tort, or indemnity.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * author(s) : Joe deBlaquiere
 */

#ifndef __ASM_ARCH_NETARM_HARDWARE_H
#define __ASM_ARCH_NETARM_HARDWARE_H
#include <asm/arch/netarm_registers.h> 
/*
 * What hardware must be present
 */
#ifndef __ASSEMBLER__

#include <linux/delay.h>

typedef unsigned long u_32;

/*
 * RAM definitions
 */
#define MAPTOPHYS(a)		((unsigned long)a)
#define KERNTOPHYS(a)		((unsigned long)(&a))
#define GET_MEMORY_END(p)	((p->u1.s.page_size) * (p->u1.s.nr_pages))
#define PARAMS_BASE			0x1000
/*#define KERNEL_BASE		(PAGE_OFFSET + 0x80000)*/

#endif

/*
 * HARD_RESET_NOW -- used in blkmem.c. Should call arch_hard_reset(), but I 
 * don't appear to have one ;).
 * --gmcnutt
 */
#if !defined(CONFIG_NETARM_NS7520) 
#define HARD_RESET_NOW()
#else  /* This might actually work for other platforms */
#define HARD_RESET_NOW() {		\
    cli();				\
    *(get_gen_reg_addr( NETARM_GEN_PLL_CONTROL )) &= 0xffff0000; \
    mdelay( 100 );  \
    *(get_gen_reg_addr( NETARM_GEN_SYSTEM_CONTROL )) |= \
            (NETARM_GEN_SYS_CFG_WDOG_EN|NETARM_GEN_SYS_CFG_WDOG_RST| \
             NETARM_GEN_SYS_CFG_WDOG_24); \
}

#endif

#ifdef CONFIG_BOARD_ARMADILLOJ

/*
 *** verison 1.0.0 Armadillo-J *** (first release version)
 *
 *  0x02000000 +---------------------+
 *             |    Reserved(boot)   | 
 *  0x02020000 +---------------------+
 *             |        Hermit       |
 *  0x02040000 +------------+--------+
 *             | Image      | Kernel |
 *  0x020B0000 |            +--------+
 *             |            |  User  |
 *  0x021E0000 +--------+   |        |
 *             | Backup |   |        |
 *  0x021F0000 +--------+   |        |
 *             | Config |   |        |
 *             +--------+---+--------+
 *
 *** version 2.0.a Armadillo-J *** (memmap changed version [type:2M])
 *
 *  0x02000000 +---------------------+
 *             | BoardParameter      |
 *  0x02010000 +------------+--------+
 *             | Image      | Kernel |
 *  0x02080000 |            +--------+
 *             |            |  User  |
 *  0x021E0000 +--------+   |        |
 *             | Backup |   |        |
 *  0x021F0000 +--------+   |        |
 *             | Config |   |        |
 *             +--------+---+--------+
 *
 *** version 2.0.b Armadillo-J *** (memmap changed version [type:4M])
 *
 *  0x02000000 +---------------------+
 *             | BoardParameter      |
 *  0x02010000 +------------+--------+
 *             | Image      | Kernel |
 *  0x02080000 |            +--------+
 *             |            |  User  |
 *  0x023E0000 +--------+   |        |
 *             | Backup |   |        |
 *  0x023F0000 +--------+   |        |
 *             | Config |   |        |
 *             +--------+---+--------+
 */

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
#define FLASH_START          (0x02000000)
#define FLASH_SIZE           (0x00200000)
#define FLASH_WIDTH          (2)

/* * [[ V100 ]] * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
#define V100_FLASH_SIZE      (0x00200000)

#define V100_RESERVED_START  (FLASH_START)
#define V100_RESERVED_OFFSET (0)
#define V100_RESERVED_SIZE   (0x00020000)

#define V100_HERMIT_START    (V100_RESERVED_START + V100_RESERVED_SIZE)
#define V100_HERMIT_OFFSET   (V100_RESERVED_OFFSET + V100_RESERVED_SIZE)
#define V100_HERMIT_SIZE     (0x00020000)

#define V100_IMAGE_START     (V100_HERMIT_START + V100_HERMIT_SIZE)
#define V100_IMAGE_OFFSET    (V100_HERMIT_OFFSET + V100_HERMIT_SIZE)
#define V100_IMAGE_SIZE      (0x001C0000)

#define V100_KERNEL_START    (V100_IMAGE_START)
#define V100_KERNEL_OFFSET   (V100_IMAGE_OFFSET)
#define V100_KERNEL_SIZE     (0x00070000)

#define V100_USER_START      (V100_KERNEL_START + V100_KERNEL_SIZE)
#define V100_USER_OFFSET     (V100_KERNEL_OFFSET + V100_KERNEL_SIZE)
#define V100_USER_SIZE       (0x00150000)

#define V100_BACKUP_START    (V100_IMAGE_START + 0x001A0000)
#define V100_BACKUP_OFFSET   (V100_IMAGE_OFFSET + 0x001A0000)
#define V100_BACKUP_SIZE     (0x00010000)

#define V100_CONFIG_START    (V100_BACKUP_START + V100_BACKUP_SIZE)
#define V100_CONFIG_OFFSET   (V100_BACKUP_OFFSET + V100_BACKUP_SIZE)
#define V100_CONFIG_SIZE     (0x00010000)

/* * [[ V20A ]] * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
#define V20A_FLASH_SIZE      (0x00200000)

#define V20A_PARAM_START     (FLASH_START)
#define V20A_PARAM_OFFSET    (0)
#define V20A_PARAM_SIZE      (0x00010000)

#define V20A_DUMMY_START     (FLASH_START)
#define V20A_DUMMY_OFFSET    (0)
#define V20A_DUMMY_SIZE      (0x00010000)

#define V20A_IMAGE_START     (V20A_PARAM_START + V20A_PARAM_SIZE)
#define V20A_IMAGE_OFFSET    (V20A_PARAM_OFFSET + V20A_PARAM_SIZE)
#define V20A_IMAGE_SIZE      (0x001f0000)

#define V20A_KERNEL_START    (V20A_IMAGE_START)
#define V20A_KERNEL_OFFSET   (V20A_IMAGE_OFFSET)
#define V20A_KERNEL_SIZE     (0x00070000)

#define V20A_USER_START      (V20A_KERNEL_START + V20A_KERNEL_SIZE)
#define V20A_USER_OFFSET     (V20A_KERNEL_OFFSET + V20A_KERNEL_SIZE)
#define V20A_USER_SIZE       (0x00180000)

#define V20A_BACKUP_START    (V20A_IMAGE_START + 0x001D0000)
#define V20A_BACKUP_OFFSET   (V20A_IMAGE_OFFSET + 0x001D0000)
#define V20A_BACKUP_SIZE     (0x00010000)

#define V20A_CONFIG_START    (V20A_BACKUP_START + V20A_BACKUP_SIZE)
#define V20A_CONFIG_OFFSET   (V20A_BACKUP_OFFSET + V20A_BACKUP_SIZE)
#define V20A_CONFIG_SIZE     (0x00010000)

/* * [[ V20B ]] * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
#define V20B_FLASH_SIZE      (0x00400000)

#define V20B_PARAM_START     (FLASH_START)
#define V20B_PARAM_OFFSET    (0)
#define V20B_PARAM_SIZE      (0x00010000)

#define V20B_DUMMY_START     (FLASH_START)
#define V20B_DUMMY_OFFSET    (0)
#define V20B_DUMMY_SIZE      (0x00010000)

#define V20B_IMAGE_START     (V20B_PARAM_START + V20B_PARAM_SIZE)
#define V20B_IMAGE_OFFSET    (V20B_PARAM_OFFSET + V20B_PARAM_SIZE)
#define V20B_IMAGE_SIZE      (0x003f0000)

#define V20B_KERNEL_START    (V20B_IMAGE_START)
#define V20B_KERNEL_OFFSET   (V20B_IMAGE_OFFSET)
#define V20B_KERNEL_SIZE     (0x00070000)

#define V20B_USER_START      (V20B_KERNEL_START + V20B_KERNEL_SIZE)
#define V20B_USER_OFFSET     (V20B_KERNEL_OFFSET + V20B_KERNEL_SIZE)
#define V20B_USER_SIZE       (0x00380000)

#define V20B_BACKUP_START    (V20B_IMAGE_START + 0x003D0000)
#define V20B_BACKUP_OFFSET   (V20B_IMAGE_OFFSET + 0x003D0000)
#define V20B_BACKUP_SIZE     (0x00010000)

#define V20B_CONFIG_START    (V20B_BACKUP_START + V20B_BACKUP_SIZE)
#define V20B_CONFIG_OFFSET   (V20B_BACKUP_OFFSET + V20B_BACKUP_SIZE)
#define V20B_CONFIG_SIZE     (0x00010000)

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
#define DRAM_START           (0x00000000)
#define DRAM_SIZE            (0x00800000)

#define FLASH_BASE           (FLASH_START)
#define FLASH_MEM_BASE       (FLASH_START)
#define DRAM_BASE            (DRAM_START)

#endif /* CONFIG_BOARD_ARMADILLOJ */

#endif

