/*
 * linux/arch/armnommu/kernel/head-arm-aj.S
 *
 * Head file for Armadillo-J
 *
 * Copyright (c) 2003 Atmark Techno, Inc.
 *
 * Author: Yasushi SHOJI <yashi@atmark-techno.com>
 *
 * Based on:
 *
 * linux/arch/armnommu/kernel/head-arm-netarm.S
 * author(s) : Joe deBlaquiere
 *
 * Copyright (C) 2000, 2001 NETsilicon, Inc.
 * Copyright (C) 2000, 2001 Red Hat, Inc.
 *
 * This software is copyrighted by Red Hat. LICENSEE agrees that
 * it will not delete this copyright notice, trademarks or protective
 * notices from any copy made by LICENSEE.
 *
 * This software is provided "AS-IS" and any express or implied 
 * warranties or conditions, including but not limited to any
 * implied warranties of merchantability and fitness for a particular
 * purpose regarding this software. In no event shall Red Hat
 * be liable for any indirect, consequential, or incidental damages,
 * loss of profits or revenue, loss of use or data, or interruption
 * of business, whether the alleged damages are labeled in contract,
 * tort, or indemnity.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * author(s) : Joe deBlaquiere
 *
 * Adapted for NS7520 (and some legacy code removed) by Art Shipkowski
 *
 * NS7520 improved code RAM copy from FS Forth-Systeme GmbH's fork.
 */

#include <linux/config.h>
#include <linux/linkage.h>
#include <asm/mach-types.h>
#include <asm/assembler.h>
#include <asm/arch/netarm_registers.h>
#include <asm/arch/netarm_mmap.h>

	.text
	.align	12

	.section ".isr_table",#alloc,#execinstr
	.type	stext, #function

ENTRY(stext)
/* 
 * these are just place holders. will be overwriten by __trap_init()
 * in entry-armv.S called by trap_init() in traps.c
 */
	b	_reset              /* Reset Vector */
	b	_jump_to_hermit     /* Undefined Vector */
	b	_jump_to_hermit     /* Software Interrupt */
	b	_jump_to_hermit     /* Abort (Prefetch) */
	b	_jump_to_hermit     /* Abort (Data) */
	b	_jump_to_hermit     /* Reserved vector */
	b	_jump_to_hermit     /* IRQ vector */
	b	_jump_to_hermit     /* Fast IRQ vector */


	.global _jump_to_hermit
_jump_to_hermit:
	mov	r0, #0x02000000
	orr	r0, r0, #0x00020000
	orr	r0, r0, #0x00000200
	mov	pc, r0



	.global _reset
_reset:
/* copy ROMFS */
#ifdef CONFIG_RAM_ATTACHED_ROMFS
	ldr	r5, =LC1
	ldmia	r5, {r5, r8}  /* r5 = _sbss, r8 = _ebss */

	mov	r0, r5
	mov	r1, r8

	ldr	r2, [r0, #+8] /* Big-endian Size */
	mov	r3, #0				 /* Init result */
	and	r4, r2, #0x000000ff
	orr	r3, r3, r4, lsl #24
	and	r4, r2, #0x0000ff00
	orr	r3, r3, r4, lsl #8
	and	r4, r2, #0x00ff0000
	orr	r3, r3, r4, lsr #8
	and	r4, r2, #0xff000000
	orr	r3, r3, r4, lsr #24
	mov	r2, r3

	add	r2, r2, #8
	and	r2, r2, #0xfffffffc

	add	r0, r0, r2 /* Copy from end */
	add	r1, r1, r2
	ldr	r3, =_ramstart
	str	r1, [r3]

_copy_romfs:
	ldr	r3,[r0,#-4]!		  /* Copy dword */
	str	r3,[r1,#-4]!
	cmp	r0, r5				/* Check if at end */
	bne	_copy_romfs
#endif

/* set to SVC mode */
	mrs	r1, cpsr		@ code from 2.0.38
	bic	r1, r1, #MODE_MASK	@ clear mode bits
	orr	r1, r1, #I_BIT|F_BIT|MODE_SVC	@ set SVC mode, disable IRQ,FIQ
	msr	cpsr, r1

/* load a few data to registers including stack pointer  */
	/* r5:	__bss_start              */
	/* r6:	processor_id             */
	/* r8:	_end                     */
	/* r9:	__machine_arch_type      */
	/* sp:	stack pointer, of cource */

	ldr	r5, =LC0
	ldmia	r5, {r5, r6, r8, r9, sp}

/* clear BSS segment */
	mov	r4, #0
1:
	cmp	r5, r8
	strcc	r4, [r5], #4
	bcc	1b

        /*  Put initial values into stack.  This would normally be done
        by sched_init() in kernel/sched.c, but that would overwrite the
        stack we're already using.  That would be bad.
        (code from the DSC21 head file by Steve Johnson) 
	Only fill half the task_union area, because the task list starts
	in the lower part. --rp */
        mov	r5, sp
        sub	r5, r5, #0x1000
        ldr	r4, L_STACK_MAGIC
        str	r4, [r5], #4
        ldr	r4, L_STACK_UNTOUCHED_MAGIC
1:
	cmp	r5, sp
        strcc	r4, [r5], #4
        bcc	1b

/* Stob in the ARMID - since we don't have CP15 to query...   */
	ldr	r2, =0x41007700
	str	r2, [r6]

/*  Pretend we know what our processor code is (for arm_id)   */
	mov     r2, #MACH_TYPE_NETARM
	str     r2, [r9]

/* Jump to linux */
	mov	fp, #0
	b	start_kernel


/* FIXME: do we need this? */
.global _netarm_led_FAIL
.global _netarm_led_FAIL2
_netarm_led_FAIL:
_netarm_led_FAIL2:
	b	_netarm_led_FAIL2


/*  These values should stay in sync with linux/kernel.h */
L_STACK_MAGIC:
	.long 0xdeadbeef
L_STACK_UNTOUCHED_MAGIC:
	.long 0xfeef1ef0



	.data
	.align	8
LC0:
	.long	__bss_start	@ r5
        .long	processor_id	@ r6
        .long	_end		@ r8
	.long   __machine_arch_type @ r9
        .long	init_task_union+8192 @ sp
#ifdef CONFIG_RAM_ATTACHED_ROMFS
LC1:
	.long	_sbss
        .long	_ebss
.global _ramstart
_ramstart:
	.long	0
#endif

	.section	.rodata
	.align	12
__zzzz:
	.space	16
	.align

	.bss
	.align	12
